/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqlt.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.cqlt.manager.SysSubjectClassManager;
import com.artfess.cqlt.model.SysSubjectClass;
import com.artfess.i18n.util.I18nUtil;
import com.artfess.poi.util.ExcelUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@Api(tags={"\u4e3b\u9898/\u4e13\u9898\u5206\u7c7b\u8868"})
@RequestMapping(value={"/sys/subject/class/"})
@ApiGroup(group={"group_biz"})
public class SysSubjectClassController
extends BaseController<SysSubjectClassManager, SysSubjectClass> {
    private static final Logger log = LoggerFactory.getLogger(SysSubjectClassController.class);

    @ApiOperation(value="\u4e3b\u9898/\u4e13\u9898\u5206\u7c7b\u8868\u5bfc\u5165")
    @PostMapping(value={"/importExcel"})
    public CommonResult<String> importExcel(@RequestParam(value="file") MultipartFile file) throws Exception {
        try {
            ExcelUtils excelUtil = new ExcelUtils(SysSubjectClass.class);
            List list = excelUtil.importExcel(null, file.getInputStream());
            boolean result = ((SysSubjectClassManager)this.baseService).importExcel(list);
            if (!result) {
                throw new IllegalArgumentException(I18nUtil.getMessage((String)"import.fail", (Locale)LocaleContextHolder.getLocale()));
            }
            return new CommonResult();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(I18nUtil.getMessage((String)"import.fail", (Locale)LocaleContextHolder.getLocale()) + "," + e.getMessage());
        }
    }
}

