/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqlt.controller;

import com.alibaba.fastjson.JSON;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.annotation.PowerLogInfo;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.DelStatusEnum;
import com.artfess.base.enums.LogType;
import com.artfess.base.enums.OperationType;
import com.artfess.base.model.CommonResult;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.cqlt.manager.QfSubjectInternationalInfoManager;
import com.artfess.cqlt.model.QfSubjectInternationalInfo;
import com.artfess.i18n.util.I18nUtil;
import com.artfess.poi.util.ExcelUtils;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@Api(tags={"\u56fd\u9645\u51c6\u5219\u79d1\u76ee\u4fe1\u606f"})
@RequestMapping(value={"/qf/subject/international/info/"})
@ApiGroup(group={"group_biz"})
public class QfSubjectInternationalInfoController
extends BaseController<QfSubjectInternationalInfoManager, QfSubjectInternationalInfo> {
    private static final Logger log = LoggerFactory.getLogger(QfSubjectInternationalInfoController.class);

    @PostMapping(value={"/"})
    @ApiOperation(value="\u6dfb\u52a0\u5b9e\u4f53\u7684\u63a5\u53e3")
    public CommonResult<String> create(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={AddGroup.class}) QfSubjectInternationalInfo t) {
        String id = ((QfSubjectInternationalInfoManager)this.baseService).newInsertTree(t);
        int length = t.getFullId().split("/").length - 1;
        t.setLevel(length + "");
        if (t.getSn() == null) {
            t.setSn(((QfSubjectInternationalInfoManager)this.baseService).getNextSequence(null));
        }
        ((QfSubjectInternationalInfoManager)this.baseService).updateById((Object)t);
        if (!StringUtils.isNotBlank((CharSequence)id)) {
            return new CommonResult(false, I18nUtil.getMessage((String)"option.fail", (Locale)LocaleContextHolder.getLocale()), null);
        }
        return new CommonResult(true, I18nUtil.getMessage((String)"option.success", (Locale)LocaleContextHolder.getLocale()), null);
    }

    @PutMapping(value={"/"})
    @ApiOperation(value="\u66f4\u65b0\u5b9e\u4f53")
    public CommonResult<String> updateById(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={UpdateGroup.class}) QfSubjectInternationalInfo t) {
        QfSubjectInternationalInfo byId = (QfSubjectInternationalInfo)((Object)((QfSubjectInternationalInfoManager)this.baseService).getById((Serializable)((Object)t.getId())));
        String id = ((QfSubjectInternationalInfoManager)this.baseService).newUpdateTree(t, byId.getName());
        int length = t.getFullId().split("/").length - 1;
        t.setLevel(length + "");
        if (t.getSn() == null) {
            t.setSn(((QfSubjectInternationalInfoManager)this.baseService).getNextSequence(null));
        }
        ((QfSubjectInternationalInfoManager)this.baseService).updateById((Object)t);
        if (!StringUtils.isNotBlank((CharSequence)id)) {
            return new CommonResult(false, I18nUtil.getMessage((String)"update.fail", (Locale)LocaleContextHolder.getLocale()), null);
        }
        return new CommonResult(true, I18nUtil.getMessage((String)"option.success", (Locale)LocaleContextHolder.getLocale()), null);
    }

    @DeleteMapping(value={"/{id}"})
    @ApiOperation(value="\u6839\u636eid\u5220\u9664")
    public CommonResult<String> deleteById(@ApiParam(name="id", value="\u5b9e\u4f53id") @PathVariable String id) {
        boolean result = ((QfSubjectInternationalInfoManager)this.baseService).removeById((Serializable)((Object)id));
        if (!result) {
            return new CommonResult(false, I18nUtil.getMessage((String)"delete.fail", (Locale)LocaleContextHolder.getLocale()), null);
        }
        return new CommonResult(true, I18nUtil.getMessage((String)"option.success", (Locale)LocaleContextHolder.getLocale()), null);
    }

    @DeleteMapping(value={"/"})
    @ApiOperation(value="\u6839\u636eid\u96c6\u5408\u6279\u91cf\u5220\u9664")
    public CommonResult<String> deleteByIds(String ... ids) {
        boolean result = ((QfSubjectInternationalInfoManager)this.baseService).removeByIds(Arrays.asList(ids));
        if (!result) {
            return new CommonResult(false, I18nUtil.getMessage((String)"delete.fail", (Locale)LocaleContextHolder.getLocale()), null);
        }
        return new CommonResult(true, I18nUtil.getMessage((String)"option.success", (Locale)LocaleContextHolder.getLocale()), null);
    }

    @PostMapping(value={"/getTree"})
    @ApiOperation(value="\u83b7\u53d6\u56fd\u9645\u51c6\u5219\u79d1\u76ee\u4fe1\u606f\u4e0b\u62c9\u6811")
    @PowerLogInfo(logType=LogType.BIZ, operaionType=OperationType.QUERY, description="\u83b7\u53d6\u56fd\u9645\u51c6\u5219\u79d1\u76ee\u4fe1\u606f\u4e0b\u62c9\u6811")
    public CommonResult<String> getTree(@ApiParam(name="model", value="\u83b7\u53d6\u8d44\u6599\u5206\u7c7b\u4e0b\u62c9\u6811") @RequestBody QfSubjectInternationalInfo entity) {
        log.info("\u83b7\u53d6\u56fd\u9645\u51c6\u5219\u79d1\u76ee\u4fe1\u606f\u4e0b\u62c9\u6811\u8bf7\u6c42\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)((Object)entity)));
        List<QfSubjectInternationalInfo> list = ((QfSubjectInternationalInfoManager)this.baseService).getTree(entity);
        return CommonResult.success(list, null);
    }

    @RequestMapping(value={"updateSequence"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u4fee\u6539\u6392\u5e8f\u53f7", notes="\u6279\u91cf\u4fee\u6539\u6392\u5e8f\u53f7")
    public CommonResult<String> updateSequence(@ApiParam(name="params", value="\u6392\u5e8f\u53c2\u6570\uff1aKey\uff1aID\uff0cValue\uff1a\u6392\u5e8f\u53f7") @RequestBody HashMap<String, Integer> params) throws Exception {
        if (!params.isEmpty()) {
            ((QfSubjectInternationalInfoManager)this.baseService).updateSequence(params);
        }
        return new CommonResult(true, I18nUtil.getMessage((String)"option.success", (Locale)LocaleContextHolder.getLocale()), null);
    }

    @PostMapping(value={"/move"})
    @ApiOperation(value="\u79fb\u52a8\u79d1\u76ee\u7684\u4e0a\u4e0b\u7ea7")
    public CommonResult<String> move(@RequestBody QfSubjectInternationalInfo entity) {
        boolean result = ((QfSubjectInternationalInfoManager)this.baseService).move(entity);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"parent_Id_", (Object)entity.getId());
        queryWrapper.eq((Object)"is_dele_", (Object)DelStatusEnum.N.getType());
        List ts = ((QfSubjectInternationalInfoManager)this.baseService).list((Wrapper)queryWrapper);
        ts.forEach(qfSubjectInfo -> {
            int length = qfSubjectInfo.getFullName().split("/").length - 1;
            qfSubjectInfo.setLevel(length + "");
        });
        ((QfSubjectInternationalInfoManager)this.baseService).updateBatchById(ts);
        if (!result) {
            return new CommonResult(false, I18nUtil.getMessage((String)"delete.fail", (Locale)LocaleContextHolder.getLocale()), null);
        }
        return new CommonResult(true, I18nUtil.getMessage((String)"option.success", (Locale)LocaleContextHolder.getLocale()), null);
    }

    @ApiOperation(value="\u56fd\u9645\u79d1\u76ee\u6570\u636e\u5bfc\u5165")
    @PostMapping(value={"/importExcel"})
    public CommonResult<String> importExcel(@RequestParam(value="file") MultipartFile file) {
        try {
            ExcelUtils excelUtil = new ExcelUtils(QfSubjectInternationalInfo.class);
            List list = excelUtil.importExcel(null, file.getInputStream());
            boolean result = ((QfSubjectInternationalInfoManager)this.baseService).importExcel(list);
            if (!result) {
                throw new IllegalArgumentException(I18nUtil.getMessage((String)"import.fail", (Locale)LocaleContextHolder.getLocale()));
            }
            return new CommonResult();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException(I18nUtil.getMessage((String)"import.fail", (Locale)LocaleContextHolder.getLocale()) + "," + e.getMessage());
        }
    }

    @ApiOperation(value="\u6279\u91cf\u4fee\u6539\u79d1\u76ee")
    @PostMapping(value={"/batchUpdate"})
    public CommonResult<String> batchUpdate() {
        try {
            boolean result = ((QfSubjectInternationalInfoManager)this.baseService).batchUpdate();
            if (!result) {
                throw new IllegalArgumentException(I18nUtil.getMessage((String)"import.fail", (Locale)LocaleContextHolder.getLocale()));
            }
            return new CommonResult();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(I18nUtil.getMessage((String)"import.fail", (Locale)LocaleContextHolder.getLocale()) + "," + e.getMessage());
        }
    }
}

