/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqlt.manager.impl;

import com.alibaba.fastjson.JSONObject;
import com.artfess.base.enums.SubjectTypeEnum;
import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.cqlt.dao.QfFinanceCfMDao;
import com.artfess.cqlt.manager.QfEnterpriseInfoManager;
import com.artfess.cqlt.manager.QfFinanceCfDManager;
import com.artfess.cqlt.manager.QfFinanceCfMManager;
import com.artfess.cqlt.manager.QfFinanceCfSManager;
import com.artfess.cqlt.manager.QfSubjectInternationalInfoManager;
import com.artfess.cqlt.model.QfEnterpriseInfo;
import com.artfess.cqlt.model.QfFinanceCfD;
import com.artfess.cqlt.model.QfFinanceCfM;
import com.artfess.cqlt.model.QfFinanceCfS;
import com.artfess.cqlt.model.QfSubjectInternationalInfo;
import com.artfess.i18n.util.I18nUtil;
import com.artfess.poi.util.HeaderNode;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.api.client.util.Sets;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class QfFinanceCfMManagerImpl
extends BaseManagerImpl<QfFinanceCfMDao, QfFinanceCfM>
implements QfFinanceCfMManager {
    @Autowired
    private QfFinanceCfDManager detailManager;
    @Autowired
    private QfFinanceCfSManager sumManager;
    @Autowired
    private QfSubjectInternationalInfoManager subjectInternationalInfoManager;
    @Autowired
    private QfEnterpriseInfoManager enterpriseInfoManager;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean insertInfo(QfFinanceCfM t) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"fill_year_", (Object)t.getFillYear());
        queryWrapper.eq((Object)"fill_month_", (Object)t.getFillMonth());
        queryWrapper.eq((Object)"report_id_", (Object)t.getReportId());
        List QfFinanceCfMS = ((QfFinanceCfMDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)QfFinanceCfMS)) {
            throw new BaseException(I18nUtil.getMessage((String)"QfOperationKpiM.repeat", (Locale)LocaleContextHolder.getLocale()));
        }
        int insert = ((QfFinanceCfMDao)this.baseMapper).insert((Object)t);
        return insert > 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateInfo(QfFinanceCfM t) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"fill_year_", (Object)t.getFillYear());
        queryWrapper.eq((Object)"fill_month_", (Object)t.getFillMonth());
        queryWrapper.eq((Object)"report_id_", (Object)t.getReportId());
        queryWrapper.ne((Object)"id_", (Object)t.getId());
        List QfFinanceCfMS = ((QfFinanceCfMDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)QfFinanceCfMS)) {
            throw new BaseException(I18nUtil.getMessage((String)"QfOperationKpiM.repeat", (Locale)LocaleContextHolder.getLocale()));
        }
        int insert = ((QfFinanceCfMDao)this.baseMapper).updateById((Object)t);
        return insert > 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateStatus(QfFinanceCfM t) {
        QfFinanceCfM QfFinanceCfM2 = (QfFinanceCfM)((Object)((QfFinanceCfMDao)this.baseMapper).selectById((Serializable)((Object)t.getId())));
        if (null == QfFinanceCfM2) {
            return false;
        }
        QfFinanceCfM2.setStatus(QfFinanceCfM2.getStatus() == 0 ? 1 : 0);
        int i = ((QfFinanceCfMDao)this.baseMapper).updateById((Object)QfFinanceCfM2);
        return i > 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean importExcel(List<HeaderNode> list, String mainId) {
        if (CollectionUtils.isEmpty(list)) {
            return false;
        }
        QfFinanceCfM mainInfo = (QfFinanceCfM)((Object)((QfFinanceCfMDao)this.baseMapper).selectById((Serializable)((Object)mainId)));
        Assert.notNull((Object)((Object)mainInfo), (String)I18nUtil.getMessage((String)"filldata.notExist", (Locale)LocaleContextHolder.getLocale()));
        this.removeInfo(mainId);
        Map<String, List<QfFinanceCfD>> historyMap = this.historyList(mainInfo);
        Map<String, QfSubjectInternationalInfo> subjectMap = this.subjectInternationalInfoManager.getSubjectCodeMap("CF");
        Map<String, QfEnterpriseInfo> enterpriseInfoMap = this.enterpriseInfoManager.getEnterpriseInfoMap(null);
        HashSet noexitSubjectCodes = Sets.newHashSet();
        List<HeaderNode> headerNodeList = list.stream().collect(Collectors.groupingBy(HeaderNode::getRow)).get(0);
        HashMap headerMap = Maps.newHashMap();
        for (HeaderNode headerNode : headerNodeList) {
            headerMap.put(headerNode.getColumn(), headerNode.getHeaderName());
        }
        Map<Integer, List<HeaderNode>> detailMap = list.stream().collect(Collectors.groupingBy(HeaderNode::getColumn));
        List<HeaderNode> subjectCodes = detailMap.get(1);
        HashMap subjectCodeMap = Maps.newHashMap();
        for (HeaderNode headerNode : subjectCodes) {
            subjectCodeMap.put(headerNode.getRow(), headerNode.getHeaderName());
        }
        HashSet subjectCodeList = Sets.newHashSet();
        int maxColumn = detailMap.size();
        ArrayList detailList = Lists.newArrayList();
        JSONObject totalInfo = new JSONObject();
        for (Map.Entry<Integer, List<HeaderNode>> entry : detailMap.entrySet()) {
            Integer column = entry.getKey();
            List<HeaderNode> nodes = entry.getValue();
            String enterpriseCode = (String)headerMap.get(column);
            List<Object> historyDetailList = Lists.newArrayList();
            if (historyMap.containsKey(enterpriseCode)) {
                historyDetailList = historyMap.get(enterpriseCode);
            }
            for (HeaderNode node : nodes) {
                if (0 == node.getRow()) continue;
                String subjectCode = (String)subjectCodeMap.get(node.getRow());
                subjectCodeList.add(subjectCode);
                if (node.getColumn() > 1 && node.getColumn() < maxColumn - 3 && !StringUtils.isEmpty((Object)node.getHeaderName())) {
                    this.createDetail(mainId, mainInfo, subjectMap, enterpriseInfoMap, noexitSubjectCodes, subjectCodeMap, detailList, enterpriseCode, historyDetailList, node);
                    continue;
                }
                if (node.getColumn() < maxColumn - 3 || StringUtils.isEmpty((Object)node.getHeaderName())) continue;
                if (node.getColumn() == maxColumn - 1) {
                    totalInfo.put(subjectCode + ":actualConsolidated", (Object)node.getHeaderName());
                    continue;
                }
                if (node.getColumn() == maxColumn - 2) {
                    totalInfo.put(subjectCode + ":actualPosting", (Object)node.getHeaderName());
                    continue;
                }
                if (node.getColumn() != maxColumn - 3) continue;
                totalInfo.put(subjectCode + ":actualTotal", (Object)node.getHeaderName());
            }
        }
        if (!CollectionUtils.isEmpty((Collection)noexitSubjectCodes)) {
            throw new BaseException(((Object)noexitSubjectCodes).toString() + I18nUtil.getMessage((String)"code.notExist", (Locale)LocaleContextHolder.getLocale()));
        }
        List<QfFinanceCfS> totalList = this.getQfFinanceCfS(mainInfo, subjectMap, new ArrayList<String>(subjectCodeList), totalInfo);
        this.sumManager.saveBatch(totalList);
        boolean b = this.detailManager.saveBatch(detailList);
        return b;
    }

    private List<QfFinanceCfS> getQfFinanceCfS(QfFinanceCfM mainInfo, Map<String, QfSubjectInternationalInfo> subjectMap, List<String> subjectCodeList, JSONObject totalInfo) {
        ArrayList totalList = Lists.newArrayList();
        subjectCodeList.forEach(subjectCode -> {
            QfFinanceCfS plS = new QfFinanceCfS();
            plS.setMainId(mainInfo.getId());
            QfSubjectInternationalInfo subjectInternationalInfo = (QfSubjectInternationalInfo)((Object)((Object)subjectMap.get(subjectCode)));
            plS.setSubjectNameEn(subjectInternationalInfo.getNameEn());
            plS.setSubjectUnit(subjectInternationalInfo.getUnit());
            plS.setSubjectName(subjectInternationalInfo.getName());
            if (totalInfo.containsKey((Object)(subjectCode + ":actualConsolidated"))) {
                plS.setActualConsolidated(totalInfo.getBigDecimal(subjectCode + ":actualConsolidated"));
            }
            if (totalInfo.containsKey((Object)(subjectCode + ":actualPosting"))) {
                plS.setActualPosting(totalInfo.getBigDecimal(subjectCode + ":actualPosting"));
            }
            if (totalInfo.containsKey((Object)(subjectCode + ":actualTotal"))) {
                plS.setActualTotal(totalInfo.getBigDecimal(subjectCode + ":actualTotal"));
            }
            plS.setFillYear(mainInfo.getFillYear());
            plS.setFillMonth(mainInfo.getFillMonth());
            plS.setFillDate(mainInfo.getFillDate());
            plS.setFillQuarter(mainInfo.getFillQuarter());
            plS.setSubjectCode((String)subjectCode);
            totalList.add(plS);
        });
        return totalList;
    }

    private void createDetail(String mainId, QfFinanceCfM mainInfo, Map<String, QfSubjectInternationalInfo> subjectMap, Map<String, QfEnterpriseInfo> enterpriseInfoMap, Set<String> noexitSubjectCodes, Map<Integer, String> subjectCodeMap, List<QfFinanceCfD> detailList, String enterpriseCode, List<QfFinanceCfD> historyDetailList, HeaderNode node) {
        try {
            Map<String, QfFinanceCfD> historyDetailMap;
            QfFinanceCfD qfFinancePlD = new QfFinanceCfD();
            qfFinancePlD.setMainId(mainId);
            qfFinancePlD.setFillDate(mainInfo.getFillDate());
            qfFinancePlD.setEnterpriseCode(enterpriseCode);
            qfFinancePlD.setSubjectCode(subjectCodeMap.get(node.getRow()));
            if (subjectMap.get(qfFinancePlD.getSubjectCode()).getType().equals(SubjectTypeEnum.XJL.getType())) {
                qfFinancePlD.setActualYtd(new BigDecimal(node.getHeaderName()).multiply(new BigDecimal(-1)));
            }
            if ((historyDetailMap = historyDetailList.stream().collect(Collectors.toMap(item -> item.getSubjectCode(), item -> item))).containsKey(qfFinancePlD.getSubjectCode())) {
                QfFinanceCfD historyDetail = historyDetailMap.get(qfFinancePlD.getSubjectCode());
                qfFinancePlD.setActual(qfFinancePlD.getActualYtd().subtract(historyDetail.getActualYtd()));
            } else {
                qfFinancePlD.setActual(qfFinancePlD.getActualYtd());
            }
            if (!subjectMap.containsKey(qfFinancePlD.getSubjectCode())) {
                noexitSubjectCodes.add(qfFinancePlD.getSubjectCode());
            } else {
                QfSubjectInternationalInfo subjectInternationalInfo = subjectMap.get(qfFinancePlD.getSubjectCode());
                qfFinancePlD.setSubjectNameEn(subjectInternationalInfo.getNameEn());
                qfFinancePlD.setSubjectUnit(subjectInternationalInfo.getUnit());
                qfFinancePlD.setSubjectName(subjectInternationalInfo.getName());
                if (!StringUtils.isEmpty((Object)subjectInternationalInfo.getLevel())) {
                    qfFinancePlD.setSubjectLevel(Integer.parseInt(subjectInternationalInfo.getLevel()));
                }
            }
            if (enterpriseInfoMap.containsKey(qfFinancePlD.getEnterpriseCode())) {
                QfEnterpriseInfo qfEnterpriseInfo = enterpriseInfoMap.get(qfFinancePlD.getEnterpriseCode());
                qfFinancePlD.setEnterpriseName(qfEnterpriseInfo.getName());
                qfFinancePlD.setEnterpriseNameEn(qfEnterpriseInfo.getNameEn());
            }
            detailList.add(qfFinancePlD);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void removeInfo(String mainId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"main_id_", (Object)mainId);
        this.detailManager.remove((Wrapper)queryWrapper);
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"main_id_", (Object)mainId);
        this.sumManager.remove((Wrapper)query);
    }

    private Map<String, List<QfFinanceCfD>> historyList(QfFinanceCfM qfFinancePlM) {
        List<QfFinanceCfD> historyList = ((QfFinanceCfMDao)this.baseMapper).historyList(qfFinancePlM.getFillMonth() - 1, qfFinancePlM.getFillYear());
        if (CollectionUtils.isEmpty(historyList)) {
            return Maps.newHashMap();
        }
        return historyList.stream().collect(Collectors.groupingBy(QfFinanceCfD::getEnterpriseCode));
    }
}

