/*
 * @Description: 
 * @Author: @liulin
 * @Date: 2023-01-30 16:21:12
 * @LastEditors: Do not edit
 * @LastEditTime: 2023-02-28 16:32:05
 */
export const TableMixin = {
    data() {
        return {
            tableMaxHeight: 600,
            showMore: false,
        }
    },
    mounted() {

        this.calcTableHeight();
        this.$root.$on("resize", () => {
            this.calcTableHeight(500);
        });
    },
    methods: {
        calcTableHeight(delay) {
            // 动态计算表格的高度，自适应当前容器
            setTimeout(() => {
                if (!this.$refs.contentPanel) {
                    return;
                }

                const contentPanelHeight = this.$refs.contentPanel.clientHeight || this.$refs.contentPanel.$el.clientHeight;
                const paginationPanelHeight = this.$refs.paginationPanel.$el.clientHeight ? 32 : 0

                let btnPanelHeight = 0
                if (this.$refs.btnPanel.clientHeight) {
                    btnPanelHeight = this.$refs.btnPanel.clientHeight
                } else if (this.$refs.btnPanel.$el && this.$refs.btnPanel.$el.clientHeight) {
                    btnPanelHeight = this.$refs.btnPanel.$el.clientHeight
                }

                console.log(contentPanelHeight, btnPanelHeight, paginationPanelHeight)
                this.tableMaxHeight =
                    contentPanelHeight -
                    btnPanelHeight -
                    paginationPanelHeight - (btnPanelHeight ? 40 : 0)

            }, delay || 0);
        },
        handleDbClick(row, column, event) {
            this.handleUpdate(row)
        },
        commonPageClick() {
            if (this.showMore) {
                this.showMore = false
            }
        }

    }
}