import req from "@/request.js";

const portal = window.context.portal;
export default {
	// 新增
	addSave(data, cb) {
		req.post(portal + `/att/waterPapers/create`, data).then(rep => {
			cb(rep.data);
		});
	},
	// 分页
	ListGet(data, cb) {
		req.post(portal + `/att/waterPapers/query`, data).then(rep => {
			cb(rep.data);
		});
	},
	// 修改
	detailId(id, cb) {
		req.get(portal + `/att/waterPapers/get/` + id).then(rep => {
			cb(rep.data);
		});
	},
	// 确认修改
	upData(data, cb) {
		req.post(portal + `/att/waterPapers/updateById`, data).then(rep => {
			cb(rep.data);
		});
	},
	//删除
	remove(ids, cb) {
		req.get(portal + `/att/waterPapers/deleteByIds?ids=` + ids).then(rep => {
			cb(rep.data);
		});
	},
	//字典
	getSys(data, cb) {
		req.post(portal + `/sys/sysDictionary/v1/queryDictItemsByCode`, data).then(rep => {
			cb(rep.data);
		});
	},
	//查看常用语详情
	detail(id, cb) {
		req.get(portal + `/innermsg/messageReceiver/v1/get?id=` + id).then(rep => {
			cb(rep.data);
		});
	},
	// 获取取水户下拉
	getwaterName(data, cb) {
		req.post(portal + `/att/waterCompany/findAll`, data).then(rep => {
			cb(rep.data);
		});
	},
	// 行政区查询接口
	getbasAdName(data, cb) {
		req.post(portal + `/sys/sysAreas/v1/tree`, data).then(rep => {
			cb(rep.data);
		});
	},

	// 取水计划

	// 新增取水计划
	addSavePlan(data, cb) {
		req.post(portal + `/att/waterPlan/create`, data).then(rep => {
			cb(rep.data);
		});
	},
	// 分页取水计划
	ListGetPlan(data, cb) {
		req.post(portal + `/att/waterPlan/query`, data).then(rep => {
			cb(rep.data);
		});
	},
	// 修改取水计划
	detailIdPlan(id, cb) {
		req.get(portal + `/att/waterPlan/get/` + id).then(rep => {
			cb(rep.data);
		});
	},
	// 确认修改取水计划
	upDataPlan(data, cb) {
		req.post(portal + `/att/waterPlan/updateById`, data).then(rep => {
			cb(rep.data);
		});
	},
	//删除取水计划
	removePlan(ids, cb) {
		req.get(portal + `/att/waterPlan/deleteByIds?ids=` + ids).then(rep => {
			cb(rep.data);
		});
	},
	// 获取取水证
	getwaterCard(data, cb) {
		req.post(portal + `/att/waterPapers/findAll`, data).then(rep => {
			cb(rep.data);
		});
	},
	//下载取水计划模板/att/waterPlan/importExcel
	downModel(data,cb) {
		req.getDown(portal + `/att/waterPlan/downModel`,'Blob',data).then(rep => {
			cb(rep);
		});
	},
	//上传
	upload(data, cb) {
		req.post(portal + `/att/waterPlan/importExcel`, data).then(rep => {
			cb(rep.data);
		});
	},
	// 取水站

	// 新增取水站
	addSaveStation(data, cb) {
		req.post(portal + `/att/waterStation/create`, data).then(rep => {
			cb(rep.data);
		});
	},
	// 分页取水站
	ListGetStation(data, cb) {
		req.post(portal + `/att/waterStation/query`, data).then(rep => {
			cb(rep.data);
		});
	},
	// 修改取水站
	detailIdStation(id, cb) {
		req.get(portal + `/att/waterStation/get/` + id).then(rep => {
			cb(rep.data);
		});
	},
	// 确认修改取水站
	upDataStation(data, cb) {
		req.post(portal + `/att/waterStation/updateById`, data).then(rep => {
			cb(rep.data);
		});
	},
	//删除取水站
	removeStation(ids, cb) {
		req.get(portal + `/att/waterStation/deleteByIds?ids=` + ids).then(rep => {
			cb(rep.data);
		});
	},
	// 获取安装位置
	positionTree(data, cb) {
		req.post(portal + `/att/waterPapers/getTree`, data).then(rep => {
			cb(rep.data);
		});
	},
}
