import req from '@/request.js'
const portal = window.context.portal
export default {
    // 添加
    addData(data, cb) {
        req.post(portal + `/qf/finance/liquidity/`, data).then(res => {
            cb(res.data)
        })
    },
   
    //删除
    delDate(ids, cb) {
        req.remove(portal + `/qf/finance/liquidity/?ids=` + ids).then(res => {
            cb(res.data)
        })
    },
    //查询
    pageQuery(data, cb) {
        req.post(portal + `/qf/finance/liquidity/query`, data).then(res => {
            cb(res.data)
        })
    },

    // id查询
    detailId(id, cb) {
        req.get(portal + `/qf/finance/liquidity/` + id).then(rep => {
            cb(rep.data)
        })
    },
    //修改状态
    editStatus(data, cb) {
        req.put(portal + `/qf/finance/liquidity/updateStatus`, data).then(res => {
            cb(res.data)
        })
    },
    //导入
    importExcel(data, cb) {
        req.post(portal + `/qf/finance/liquidity/importExcel`, data).then(res => {
            cb(res.data)
        })
    },
    //导出
    export(data, cb) {
        req.post(portal + `/qf/finance/liquidity/export`, data, 'blob').then(res => {
            cb(res.data)
        })
    },
    /*二级页面*/
    //批量添加
    batchUpdateData(data, cb) {
        req.put(portal + `/qf/finance/liquidity/detail/batchUpdate`, data).then(res => {
            cb(res.data)
        })
    },
    //表格查询
    detailQuery(data, cb) {
        req.post(portal + `/qf/finance/liquidity/detail/query`, data).then(res => {
            cb(res.data)
        })
    },
    //表头表格查询
    headerDetailQuery(data, cb) {
        req.post(portal + `/qf/finance/liquidity/detail/detailQuery`, data).then(res => {
            cb(res.data)
        })
    },
}
