import req from '@/request.js'
const portal = window.context.portal
export default {
	// 添加
	addData(data, cb) {
		req.post(portal + `/qf/operation/newOrders/`, data).then(res => {
			cb(res.data)
		})
	},
	//修改
	editData(data, cb) {
		req.put(portal + `/qf/operation/newOrdersDetail/batchUpdate`, data).then(res => {
			cb(res.data)
		})
	},
	//删除
	delDate(ids, cb) {
		req.remove(portal + `/qf/operation/newOrders/?ids=` + ids).then(res => {
			cb(res.data)
		})
	},
	//查询
	pageQuery(data, cb) {
		req.post(portal + `/qf/operation/newOrders/query`, data).then(res => {
			cb(res.data)
		})
	},

	// id查询
	detailId(id, cb) {
		req.get(portal + `/qf/operation/newOrders/` + id).then(rep => {
			cb(rep.data)
		})
	},
	//修改状态
	editStatus(data, cb) {
		req.put(portal + `/qf/operation/newOrders/updateStatus`, data).then(res => {
			cb(res.data)
		})
	},
	//导入
	importExcel(data, cb) {
		req.post(portal + `/qf/operation/newOrders/importExcel`, data).then(res => {
			cb(res.data)
		})
	},
	//导出
	export (data, cb) {
		req.post(portal + `/qf/operation/newOrders/export`, data,'blob').then(res => {
			cb(res.data)
		})
	},
	/*二级页面*/
	//批量添加
	saveData(data, cb) {
		req.post(portal + `/qf/operation/newOrdersDetail/batchSave`, data).then(res => {
			cb(res.data)
		})
	},
	//表格查询
	detailQuery(data, cb) {
		req.post(portal + `/qf/operation/newOrdersDetail/query`, data).then(res => {
			cb(res.data)
		})
	},
	//批量删除
	dleDetail(ids, cb) {
		req.remove(portal + `/qf/operation/newOrdersDetail/?ids=` + ids).then(res => {
			cb(res.data)
		})
	},

}
