import req from '@/request.js'
const portal = window.context.portal
export default {
    // 添加
    addData(data, cb) {
        req.post(portal + `/qf/finance/cf/v1/`, data).then(res => {
            cb(res.data)
        })
    },
    //修改
    editData(data, cb) {
        req.put(portal + `/qf/finance/cf/v1/`, data).then(res => {
            cb(res.data)
        })
    },
    //删除
    delDate(ids, cb) {
        req.remove(portal + `/qf/finance/cf/v1/?ids=` + ids).then(res => {
            cb(res.data)
        })
    },
    //查询
    pageQuery(data, cb) {
        req.post(portal + `/qf/finance/cf/v1/query`, data).then(res => {
            cb(res.data)
        })
    },

    // id查询
    detailId(id, cb) {
        req.get(portal + `/qf/finance/cf/v1/` + id).then(rep => {
            cb(rep.data)
        })
    },
    //修改状态
    editStatus(data, cb) {
        req.put(portal + `/qf/finance/cf/v1/updateStatus`, data).then(res => {
            cb(res.data)
        })
    },
    //导入
    importExcel(data, cb) {
        req.post(portal + `/qf/finance/cf/v1/importExcel`, data).then(res => {
            cb(res.data)
        })
    },
    //导出
    export(data, cb) {
        req.post(portal + `/qf/finance/cf/v1/export`, data, 'blob').then(res => {
            cb(res.data)
        })
    },
    /*二级页面*/
    //批量添加
    batchUpdateData(data, cb) {
        req.put(portal + `/qf/finance/cf/detail/batchUpdate`, data).then(res => {
            cb(res.data)
        })
    },
    //表格查询
    detailQuery(data, cb) {
        req.post(portal + `/qf/finance/cf/detail/query`, data).then(res => {
            cb(res.data)
        })
    },
    //表头表格查询
    headerDetailQuery(data, cb) {
        req.post(portal + `/qf/finance/cf/detail/detailQuery`, data).then(res => {
            cb(res.data)
        })
    },
}
