package com.artfess.uc.model;
import org.apache.commons.lang.builder.ToStringBuilder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.artfess.base.entity.BaseModel;
import java.time.LocalDateTime;

/**
* 排班用户
* <pre> 
* 描述：排班用户 实体对象
* 构建组：x7
* 作者:qiuxd
* 邮箱:qiuxd@jee-soft.cn
* 日期:2020-08-05 14:22:59
* 版权：广州宏天软件股份有限公司
* </pre>
*/
@TableName("uc_shift_user")
@ApiModel(value = "ShiftUser",description = "排班用户")
public class ShiftUser extends UcBaseModel<ShiftUser>{

   private static final long serialVersionUID = 1L;
   @XmlTransient
   @TableId("ID_")
   @ApiModelProperty(value="主键")
   protected String id; 
   
   @XmlAttribute(name = "userId")
   @TableField("USER_ID_")
   @ApiModelProperty(value="用户ID")
   protected String userId; 
   
   @XmlAttribute(name = "shiftId")
   @TableField("SHIFT_ID_")
   @ApiModelProperty(value="排班ID")
   protected String shiftId;
   
   
   public void setId(String id) {
       this.id = id;
   }
   
   /**
    * 返回 主键
    * @return
    */
   public String getId() {
       return this.id;
   }
   public void setUserId(String userId) {
       this.userId = userId;
   }
   
   /**
    * 返回 用户ID
    * @return
    */
   public String getUserId() {
       return this.userId;
   }
   public void setShiftId(String shiftId) {
       this.shiftId = shiftId;
   }
   
   /**
    * 返回 排班ID
    * @return
    */
   public String getShiftId() {
       return this.shiftId;
   }

   /**
    * @see Object#toString()
    */
   public String toString() {
       return new ToStringBuilder(this)
       .append("id", this.id) 
       .append("userId", this.userId) 
       .append("shiftId", this.shiftId)
       .toString();
   }
}