package com.artfess.form.model;

import com.artfess.base.entity.AutoFillModel;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * 表单form_html历史数据
 * <pre> 
 * 描述：表单form_html历史数据 实体对象
 * 构建组：x7
 * 作者:zhaoxy
 * 邮箱:zhaoxy@jee-soft.cn
 * 日期:2019-11-19 10:03:35
 * 版权：广州宏天软件股份有限公司
 * </pre>
 */
@ApiModel("表单form_html历史数据")
@TableName("form_history_record")
public class FormHistoryRecord extends AutoFillModel<FormHistoryRecord> {

	private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    @TableId("id_")
	protected String id;

    @ApiModelProperty("表单ID")
    @TableField("form_id_")
	protected String formId;
    
	@ApiModelProperty(name="formKey", notes="对应表单key")
	@TableField("form_key_")
	protected String formKey;

	@ApiModelProperty(name="version", notes="表单版本")
	@TableField("version_")
	protected Integer version;

    @ApiModelProperty("表单HTML内容")
    @TableField("form_html_")
	protected String formHtml;

    @ApiModelProperty("表单JSON数据")
    @TableField("form_expand_")
    protected String formExpand;

    //@ApiModelProperty(value = "创建时间", hidden=true, accessMode= ApiModelProperty.AccessMode.READ_ONLY)
    //@TableField(value="create_time_", fill= FieldFill.INSERT, select=true)
    //private LocalDateTime createTime;
    
    public FormHistoryRecord(){
		
	}
    
    public FormHistoryRecord(Form bpmForm){
		this.formId = bpmForm.getId(); /*对应表单ID*/
		this.formKey = bpmForm.getFormKey();
		this.version = bpmForm.getVersion(); 
		this.formHtml = bpmForm.getFormHtml(); /*表单设计（HTML代码）*/
        this.formExpand = bpmForm.getExpand(); /*表单设计（JSON数据）*/
	}
	
	public void setId(String id) {
		this.id = id;
	}
	
	/**
	 * 返回 主键ID
	 * @return
	 */
	public String getId() {
		return this.id;
	}

    public String getFormId() {
        return formId;
    }

    public void setFormId(String formId) {
        this.formId = formId;
    }

    public String getFormKey() {
		return formKey;
	}

	public void setFormKey(String formKey) {
		this.formKey = formKey;
	}

	public Integer getVersion() {
		return version;
	}

	public void setVersion(Integer version) {
		this.version = version;
	}

	public void setFormHtml(String formHtml) {
		this.formHtml = formHtml;
	}
	
	/**
	 * 返回 表单定义HTML
	 * @return
	 */
	public String getFormHtml() {
		return this.formHtml;
	}

    public String getFormExpand() {
        return formExpand;
    }

    public void setFormExpand(String formExpand) {
        this.formExpand = formExpand;
    }

    /**
	 * @see Object#toString()
	 */
	public String toString() {
		return new ToStringBuilder(this)
		.append("id", this.id) 
		.append("formId", this.formId)
		.append("formHtml", this.formHtml)
        .append("formExpand", this.formExpand)
		.toString();
	}
}