package com.artfess.base.sqlbuilder;

import com.artfess.base.query.QueryOP;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.fasterxml.jackson.databind.node.ObjectNode;




public class SqlServerSqlBuilder extends AbstractSqlBuilder {

	@Override
	public void handleDbTypeEqualDate(StringBuffer sql, String field, QueryOP op, Object value, String format) {
		if (op == QueryOP.BETWEEN) {
			ObjectNode value1 = (ObjectNode) value;
			String start = JsonUtil.getString( value1,"start","");
			String end = JsonUtil.getString(value1, "end", "");
			if (StringUtil.isNotEmpty(start)) {
				sql.append(" and " + field + " " + ">=" + " '" + start + "'");
			}
			if (StringUtil.isNotEmpty(end)) {
				sql.append(" and " + field + " " + "<=" + " '" + end + "'");
			}
		} else {
			sql.append(" and " + field + " " + op.op() + " '" + value.toString() + "'");
		}

	}

}
