package com.artfess.base.aop;

import com.artfess.base.cache.annotation.Cacheable;
import com.artfess.base.constants.CacheKeyConst;
import com.artfess.base.feign.ApplicationFeignService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Map;

@Service
public class AopCacheHelper {
	
	@Resource
	ApplicationFeignService applicationFeignService;
	
	@Cacheable(value = CacheKeyConst.EIP_SYS_DATA_PERMISSION, key="#key")
	public String getDataPermissionFromCache(String key) {
		return null;
	}
	
	@Cacheable(value = CacheKeyConst.EIP_SYS_LOGS_SETTING_STATUS, key=CacheKeyConst.EIP_SYS_LOGS_SETTING_STATUS_KEY, pureKey = true)
	public Map<String, String> getSysLogsSettingStatusMap(){
		return applicationFeignService.getSysLogsSettingStatusMap();
	}
}
