package com.artfess.base.annotation;

import com.artfess.base.enums.LogType;
import com.artfess.base.enums.OperationType;

import java.lang.annotation.*;

/**
 * Swagger接口文档分组注解
 * <pre>
 * 在Controller类上添加该注解，在注解中指定日志的授权类型，只要。
 * </pre>
 *
 * @company 阿特菲斯信息技术有限公司
 * @author heyifan
 * @email heyf@jee-soft.cn
 * @date 2020年4月1日
 */
@Inherited
@Documented
@Target({ElementType.METHOD, ElementType.TYPE})
@Retention(RetentionPolicy.RUNTIME)
public @interface PowerLogInfo {
    LogType logType();  //日志类型
    OperationType operaionType(); //操作类型
    String description(); //描述
}