package com.artfess.manage.safty.model;


import com.artfess.base.annotation.Excel;
import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 安全隐患排查对象(CmgtSaftyDangerUnit)表实体类
 *
 * @author 黎沐华
 * @since 2023-05-05 15:07:34
 */
@Data
@TableName("CMGT_SAFTY_DANGER_UNIT")
@ApiModel("安全隐患排查对象(CmgtSaftyDangerUnit)表实体类")
public class CmgtSaftyDangerUnit extends AutoFillModel<CmgtSaftyDangerUnit> {

    @NotNull(message = "修改必须指定id", groups = {UpdateGroup.class})
    @Null(message = "新增不能指定id", groups = {AddGroup.class})
    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @Excel(name = "单位类型", column = "B")
    @ApiModelProperty("单位类别（1：九小场所 2：重点单位 3：其它），使用字典zhgl-dwlx")
    @TableField("type_")
    private String type;

    @Excel(name = "单位名称", column = "D")
    @ApiModelProperty("单位（场所）名称")
    @TableField("unit_name_")
    private String unitName;

    @Excel(name = "单位地址", column = "E")
    @ApiModelProperty("单位（场所）地址")
    @TableField("unit_address_")
    private String unitAddress;

    @Excel(name = "负责人", column = "F")
    @ApiModelProperty("负责人姓名")
    @TableField("name_")
    private String name;

    @Excel(name = "联系电话", column = "G")
    @ApiModelProperty("负责人电话")
    @TableField("phone_")
    private String phone;

    @ApiModelProperty("重点单位分类，用于区分是否是内部单位，如果不是，则需要在备注中说明（参考字典 zddwfl）")
    @TableField("emphasis_type_")
    private String emphasisType;

    @Excel(name = "重点单位级别", column = "L")
    @ApiModelProperty("重点单位级别， 使用字典zddwjb")
    @TableField("emphasis_level_")
    private String emphasisLevel;

    @Excel(name = "场所类型", column = "H")
    @ApiModelProperty("九小场所分类（参考字典 jxcslx）")
    @TableField("small_place_type_")
    private String smallPlaceType;

    @Excel(name = "所属片区", column = "C")
    @ApiModelProperty("九小场所片区（参考字典 jxcspq）")
    @TableField("small_place_area_")
    private String smallPlaceArea;

    @ApiModelProperty("场所面积（平米）")
    @TableField("area_")
    private BigDecimal area;

    @Excel(name = "员工数量", column = "I")
    @ApiModelProperty("从业员工数量")
    @TableField("employees_")
    private Integer employees;

    @ApiModelProperty("道路门牌号")
    @TableField("road_num_")
    private String roadNum;

    @ApiModelProperty("是否三合一（1：是 2：否）, 使用字典ty-sf")
    @TableField("is_shy_")
    private String isShy;

    @ApiModelProperty("安全隐患分类（字典 cmgt_aqyhlx：多选）")
    @TableField("content_")
    private String content;

    @Excel(name = "使用燃料种类", column = "K")
    @ApiModelProperty("燃料种类（字典 rlzl：多选）")
    @TableField("fuel_type_")
    private String fuelType;

    @Excel(name = "风险级别", column = "J")
    @ApiModelProperty("风险级别（字典）fxjb")
    @TableField("risk_level_")
    private String riskLevel;

    @ApiModelProperty("排序")
    @TableField("sn_")
    private Integer sn;

    @Excel(name = "备注", column = "M")
    @ApiModelProperty("备注, 如果重点单位分类emphasisType为外部单位，则必须在memo中说明")
    @TableField("memo_")
    private String memo;

    @ApiModelProperty(value = "删除标识，1已删除，0未删除")
    @TableField("is_dele_")
    private String isDele;

    @ApiModelProperty(value = "版本号")
    @TableField("version_")
    private Integer version;

    @ApiModelProperty(value = "数据时间戳")
    @TableField("last_time_")
    private LocalDateTime lastTime;

}

