package com.artfess.manage.safty.manager.impl;


import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.manage.safty.dao.CmgtSaftyDangerCheckplanDao;
import com.artfess.manage.safty.dao.CmgtSaftyDangerUnitDao;
import com.artfess.manage.safty.manager.CmgtSaftyDangerCheckplanManager;
import com.artfess.manage.safty.manager.dto.CmgtSaftyDangerCheckplanDto;
import com.artfess.manage.safty.manager.mapper.CmgtSaftyDangerCheckplanDtoMapper;
import com.artfess.manage.safty.model.CmgtSaftyDangerCheckplan;
import com.artfess.manage.safty.model.CmgtSaftyDangerUnit;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.stream.Collectors;

/**
 * 安全隐患排查计划 服务实现类
 *
 * @author wujl
 * @company 阿特菲斯信息技术有限公司
 * @since 2022-08-01
 */
@Service
public class CmgtSaftyDangerCheckplanManagerImpl extends BaseManagerImpl<CmgtSaftyDangerCheckplanDao, CmgtSaftyDangerCheckplan> implements CmgtSaftyDangerCheckplanManager {

    @Resource
    private CmgtSaftyDangerCheckplanDao cmgtSaftyDangerCheckplanDao;

    @Resource
    private CmgtSaftyDangerCheckplanDtoMapper cmgtSaftyDangerCheckplanDtoMapper;

    @Resource
    private CmgtSaftyDangerUnitDao cmgtSaftyDangerUnitDao;

    @Override
    public PageList<CmgtSaftyDangerCheckplanDto> pageQuery(QueryFilter<CmgtSaftyDangerCheckplan> queryFilter) {
        PageList<CmgtSaftyDangerCheckplan> result = query(queryFilter);
        PageList<CmgtSaftyDangerCheckplanDto> r = new PageList<CmgtSaftyDangerCheckplanDto>(
                result.getRows().stream().map(e -> {
                            CmgtSaftyDangerCheckplanDto t = cmgtSaftyDangerCheckplanDtoMapper.toDto(e);
                            if (t.getRecipient() != null) {
                                t.setCmgtSaftyDangerUnit(cmgtSaftyDangerUnitDao.selectById(t.getRecipient()));
                            } else {
                                t.setCmgtSaftyDangerUnit(new CmgtSaftyDangerUnit());
                            }
                            return t;
                        }
                ).collect(Collectors.toList())
        );
        r.setTotal(result.getTotal());
        r.setPage(result.getPage());
        r.setPageSize(result.getPageSize());
        return r;
    }

    @Override
    public String createInfo(CmgtSaftyDangerCheckplan t) {
        int i = this.baseMapper.insert(t);
        if (i > 0) {
            return t.getId();
        }
        return null;
    }

    @Override
    public String updateInfo(CmgtSaftyDangerCheckplan t) {
        this.baseMapper.updateById(t);
        return t.getId();
    }

    @Override
    public void deleteInfo(CmgtSaftyDangerCheckplan t) {
        this.baseMapper.deleteById(t.getId());
    }
}
