package com.artfess.manage.mq;

import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONUtil;
import com.artfess.manage.dwd.manager.DwdSjWeatherPhenoMiManager;
import com.artfess.manage.dwd.model.DwdSjWeatherPhenoMi;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.apache.rocketmq.spring.core.RocketMQListener;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * @author Dominick Li
 * @CreateTime 2020/3/22 21:06
 * @description 如果consumerGroup的名称不同, 则会产生重复消费的情况，例如 consumer1和consumer2
 * 如果一个top下面有多个consumerGroup组,则消费者 消费消息会根据组的长度取模
 **/
@Service
//@RocketMQMessageListener(topic = "xztq_weather_pheno_mi_topic", consumerGroup = "xztq_weather_pheno_mi_group")
public class WeatherPhenoConsumer implements
        RocketMQListener<String> {

    @Resource
    private DwdSjWeatherPhenoMiManager dwdSjWeatherPhenoMiManager;

    @Override
    public void onMessage(String msg) {
        System.out.println("xztq_weather_pheno_mi_group开始消费=================:" + msg);
        //{
//            "data":[{
//            "date":"2022-09-11", "code_day":"0", "rainfall":"0.00", "text_night":"晴", "insert_time":
//            "2022\/09\/09 15:18:49.000000000", "wind_direction":"东", "high":"28", "update_time":
//            "2022\/09\/09 15:18:49.000000000", "precip":"0.00", "low":"17", "wind_scale":"1", "text_day":
//            "晴", "wind_direction_degree":"112", "humidity":"82", "wind_speed":"3.74", "code_night":"1"
//        }]
//        }
        JSONArray ds = JSONUtil.parseObj(msg).getJSONArray("data");
        for (int i = 0; i < ds.size(); i++) {
            DwdSjWeatherPhenoMi mi = JSONUtil.toBean(ds.getJSONObject(0), DwdSjWeatherPhenoMi.class);
            mi.setAreaId(mi.getId());
            mi.setId(null);
            dwdSjWeatherPhenoMiManager.createInfo(mi);
        }


    }
}
