package com.artfess.manage.material.vo;

import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.manage.material.model.CmgtMaterialFlowLog;
import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.math.BigDecimal;
import java.util.List;

/**
 * 物资领用vo
 *
 * @Author : min.wu
 * @Date: 2023/05/04 17:58
 */
@Data
@ApiModel(value="物资领用vo")
public class RecipientsVo {

    @ApiModelProperty(value = "领用单ID")
    private String purchasingId;

    @NotBlank(message = "请选择仓库",groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "所属仓库(参考字典)")
    private String warehouse;

    @NotBlank(message = "请选择领用人",groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "领用人")
    private String fortheUser;

    @NotBlank(message = "请选择领用部门",groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "领用部门")
    private String fortheOrg;

    @ApiModelProperty(value = "领用物资明细")
    private List<CmgtMaterialFlowLog> list;

}
