package com.artfess.manage.material.model;

import java.math.BigDecimal;

import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.extension.activerecord.Model;

import java.time.LocalDate;
import java.time.LocalDateTime;

import com.baomidou.mybatisplus.annotation.TableId;

import java.io.Serializable;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;

/**
 * 采购订单表
 *
 * @author min.wu
 * @company 阿特菲斯信息技术有限公司
 * @since 2023-04-24
 */
@Data
@ApiModel(value = "CmgtMaterialOrder对象", description = "采购订单表")
public class CmgtMaterialOrder extends AutoFillModel<CmgtMaterialOrder> {

    private static final long serialVersionUID = 1L;

    @NotNull(message = "修改必须指定id", groups = {UpdateGroup.class})
    @Null(message = "新增不能指定id", groups = {AddGroup.class})
    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @NotBlank(message = "请输入采购单号", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "采购单号")
    @TableField("code_")
    private String code;

    @NotBlank(message = "请输入采购订单标题", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "采购订单标题")
    @TableField("plan_title_")
    private String planTitle;

    @NotBlank(message = "请选择采购部门", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "采购部门")
    @TableField("org_name_")
    private String orgName;

    @ApiModelProperty(value = "采购执行人")
    @TableField("plan_user_")
    private String planUser;

    @ApiModelProperty(value = "计划生成日期")
    @TableField("plan_date_")
    private LocalDate planDate = LocalDate.now();

    @ApiModelProperty(value = "采购单状态（1：已下单 2：已完成）")
    @TableField("status_")
    private String status;

    @ApiModelProperty(value = "采购总价")
    @TableField("total_price_")
    private BigDecimal totalPrice;

    @ApiModelProperty(value = "供应商_名称（可以选择多个供应商 | ）")
    @TableField("supplier_name_")
    private String supplierName;

    @ApiModelProperty(value = "采购订单到货完成时间")
    @TableField("complete_date_")
    private LocalDateTime completeDate;

    @ApiModelProperty(value = "排序")
    @TableField("sn_")
    private Integer sn;

    @ApiModelProperty(value = "备注")
    @TableField("memo_")
    private String memo;

    @TableLogic
    @ApiModelProperty(value = "是否已删，1已删除，0未删除")
    @TableField(value = "IS_DELE_", updateStrategy = FieldStrategy.NOT_EMPTY)
    private String isDele;

    @ApiModelProperty(value = "数据时间戳")
    @TableField("last_time_")
    private LocalDateTime lastTime = LocalDateTime.now();


    @ApiModelProperty(value = "采购订单明细")
    @TableField(exist = false)
    private List<CmgtMaterialOrderDetail> detailList;

    @ApiModelProperty(value = "供应商明细")
    @TableField(exist = false)
    private List<CmgtMaterialOrderSupplier> supplierList;

}
