package com.artfess.manage.material.manager.impl;


import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.manage.material.dao.CmgtMaterialCustomDao;
import com.artfess.manage.material.manager.CmgtMaterialCustomManager;
import com.artfess.manage.material.model.CmgtMaterialCustom;
import org.springframework.stereotype.Service;

import java.util.List;



/**
 * 物资供应商信息 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author fanxm
 * @since 2022-08-24
 */
@Service
public class CmgtMaterialCustomManagerImpl extends BaseManagerImpl<CmgtMaterialCustomDao, CmgtMaterialCustom> implements CmgtMaterialCustomManager {

    @Override
    public String createInfo(CmgtMaterialCustom t) {
        int i = this.baseMapper.insert(t);
        if(i>0){
            return t.getId();
        }
        return null;
    }

    @Override
    public String updateInfo(CmgtMaterialCustom t) {
        this.baseMapper.updateById(t);
        return t.getId();
    }

    @Override
    public void deleteInfo(CmgtMaterialCustom t) {
        this.baseMapper.deleteById(t.getId());
    }

    @Override
    public boolean delete(List<String> ids) {
        for (String id : ids) {

            int count = this.baseMapper.deleteById(id);
            if (count == 0) {
                return false;
            }
        }
        return true;
    }




}
