package com.artfess.manage.material.manager.dto;

import com.artfess.manage.base.ManageBaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;


/**
 * cmgt_material_warehouse_inout_detail
 *
 * @author yuanhc
 * @company 阿特菲斯信息技术有限公司
 * @since 2022-09-05
 */
@Data
@ApiModel(value = "CmgtMaterialWarehouseInoutDetailDto", description = "物资出入库明细DTO对象")
public class CmgtMaterialWarehouseInoutDetailDto extends ManageBaseModel<CmgtMaterialWarehouseInoutDetailDto> {


    /**
     * 主键_ID
     */
    @ApiModelProperty(value = "主键_ID")
    private String id;


    /**
     * 出入库ID
     */
    @ApiModelProperty(value = "出入库ID")
    private String warehouseInoutId;


    /**
     * 物资ID
     */
    @ApiModelProperty(value = "物资ID")
    private String materialInfoId;


    /**
     * 库存ID
     */
    @ApiModelProperty(value = "库存ID")
    private String quantityId;


    /**
     * 品名
     */
    @ApiModelProperty(value = "品名")
    private String name;


    /**
     * 型号
     */
    @ApiModelProperty(value = "型号")
    private String model;


    /**
     * 数量
     */
    @ApiModelProperty(value = "数量")
    private BigDecimal quantity;


    @ApiModelProperty(value = "可用数量")
    private BigDecimal availableQuantity;


    /**
     * 单价
     */
    @ApiModelProperty(value = "单价")
    private BigDecimal price;


    /**
     * 总价
     */
    @ApiModelProperty(value = "总价")
    private BigDecimal amount;


    /**
     * 供应商
     */
    @ApiModelProperty(value = "供应商")
    private String supplier;


    /**
     * 描述
     */
    @ApiModelProperty(value = "描述")
    private String description;


    /**
     * 排序
     */
    @ApiModelProperty(value = "排序")
    private Integer sn;


    /**
     * 备注
     */
    @ApiModelProperty(value = "备注")
    private String memo;


    /**
     * 单位
     */
    @ApiModelProperty(value = "单位")
    private String unit;


    /**
     * 申请人
     */
    @ApiModelProperty(value = "申请人")
    private String applicant;

    @ApiModelProperty(value = "申请人ID")
    private String applicantId;


    @ApiModelProperty(value = "")
    private LocalDate inoutDate;


    /**
     * 所属部门
     */
    @ApiModelProperty(value = "所属部门")
    private String orgId;


    /**
     * 所属仓库
     */
    @ApiModelProperty(value = "所属仓库")
    private String warehouse;


    @ApiModelProperty(value = "")
    private String status;


    private String createByName;

}
