package com.artfess.manage.material.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.context.BaseContext;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.i18n.util.I18nUtil;
import com.artfess.manage.material.manager.CmgtMaterialUsedDetailManager;
import com.artfess.manage.material.model.CmgtMaterialUsedDetail;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.apache.poi.ss.formula.functions.T;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.List;

/**
 * 常用物资-明细表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-04-24
 */
@Slf4j
@RestController
@Api(tags = "物资管理-常用物资")
@RequestMapping("/manager/material/usedDetail/")
@ApiGroup(group = {ApiGroupConsts.MANAGER_BIZ})
public class CmgtMaterialUsedDetailController extends BaseController<CmgtMaterialUsedDetailManager, CmgtMaterialUsedDetail> {

    @Resource
    BaseContext baseContext;

    @Override
    @PostMapping("/")
    @ApiOperation("添加实体的接口")
    public CommonResult<String> create(@ApiParam(name = "model", value = "实体信息") @RequestBody @Validated({AddGroup.class}) CmgtMaterialUsedDetail t) {
        boolean save = baseService.save(t);
        if (t.getSn() == null) {
            t.setSn(baseService.getNextSequence(null));
        }
        baseService.updateById(t);
        if (!save) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult<>();
    }

    @Override
    @PutMapping("/")
    @ApiOperation("更新实体")
    public CommonResult<String> updateById(@ApiParam(name = "model", value = "实体信息") @RequestBody @Validated({UpdateGroup.class}) CmgtMaterialUsedDetail t) {
        if (t.getSn() == null) {
            t.setSn(baseService.getNextSequence(null));
        }
        boolean b = baseService.updateById(t);
        if (!b) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult<>();
    }


    @Override
    @RequestMapping(value = "updateSequence", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "批量修改排序号", notes = "批量修改排序号")
    public CommonResult<String> updateSequence(@ApiParam(name = "params", value = "排序参数：Key：ID，Value：排序号") @RequestBody HashMap<String, Integer> params) throws Exception {
        if(!params.isEmpty()){
            baseService.updateSequence(params);
        }
        return new CommonResult<String>(true, I18nUtil.getMessage("option.success", LocaleContextHolder.getLocale()), null);
    }

    @PostMapping(value="/findByOrgUseDetail", produces={"application/json; charset=utf-8" })
    @ApiOperation("根据条件获取该部门常用物资")
    public CommonResult<CmgtMaterialUsedDetail> findByOrgUseDetail(@ApiParam(name="model", value="常用物资查询条件") @RequestBody CmgtMaterialUsedDetail usedDetail) {
        String currentOrgId = baseContext.getCurrentOrgId();
        usedDetail.setCreateOrgId(currentOrgId);
        List<CmgtMaterialUsedDetail> list = baseService.findByOrgUseDetail(usedDetail);

        return CommonResult.success(list, null);
    }


}
