package com.artfess.manage.material.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.annotation.PowerLogInfo;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.LogType;
import com.artfess.base.enums.OperationType;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.i18n.util.I18nUtil;
import com.artfess.manage.material.manager.CmgtMaterialClassManager;
import com.artfess.manage.material.model.CmgtMaterialClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.HashMap;
import java.util.List;

/**
 * 物资分类 前端控制器
 *
 * @author 超级管理员
 * @company 阿特菲斯信息技术有限公司
 * @email wujl
 * @since 2022-07-21
 */
@Slf4j
@RestController
@Api(tags = "物资管理-物资分类")
@RequestMapping("/manager/material/class")
@ApiGroup(group = {ApiGroupConsts.MANAGER_BIZ})
public class CmgtMaterialClassController extends BaseController<CmgtMaterialClassManager, CmgtMaterialClass> {

    @Autowired
    private CmgtMaterialClassManager cmgtMaterialClassManager;

    @Override
    @PostMapping("/")
    @ApiOperation("添加实体的接口")
    public CommonResult<String> create(@ApiParam(name = "model", value = "实体信息") @RequestBody @Validated({AddGroup.class}) CmgtMaterialClass t) {
        String id = baseService.insertTree(t);
        if (t.getSn() == null) {
            t.setSn(baseService.getNextSequence(null));
        }
        baseService.updateById(t);
        if (!StringUtils.isNotBlank(id)) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult<>();
    }

    @Override
    @PutMapping("/")
    @ApiOperation("更新实体")
    public CommonResult<String> updateById(@ApiParam(name = "model", value = "实体信息") @RequestBody @Validated({UpdateGroup.class}) CmgtMaterialClass t) {
        CmgtMaterialClass byId = baseService.getById(t.getId());
        if(null == byId) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, null);
        }

        String id = baseService.updateTree(t, byId.getName());

        if (t.getSn() == null) {
            t.setSn(baseService.getNextSequence(null));
        }
        baseService.updateById(t);
        if (!StringUtils.isNotBlank(id)) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult<>();
    }

    @GetMapping(value = "/findAll", produces = {"application/json; charset=utf-8"})
    @ApiOperation("获取物资分类下拉树")
    @PowerLogInfo(logType = LogType.BIZ, operaionType = OperationType.QUERY, description = "获取物资分类下拉树")
    public CommonResult<String> getTree() {
        List<CmgtMaterialClass> l = cmgtMaterialClassManager.findAllClass();
        List<CmgtMaterialClass> list = BeanUtils.listToTree(l);
        return CommonResult.success(list, null);
    }


}
