package com.artfess.manage.dwd.manager.impl;


import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.manage.base.ManageCommonService;
import com.artfess.manage.dwd.dao.DwdSjWeatherPhenoMiDao;
import com.artfess.manage.dwd.manager.DwdSjWeatherPhenoMiManager;
import com.artfess.manage.dwd.manager.dto.DwdSjWeatherPhenoMiDto;
import com.artfess.manage.dwd.manager.mapper.DwdSjWeatherPhenoMiDtoMapper;
import com.artfess.manage.dwd.model.DwdSjWeatherPhenoMi;
import com.artfess.uc.dao.UserDao;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.stream.Collectors;



/**
 * 来自互联网心知天气的天气现象 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author yuanhc
 * @since 2022-09-21
 */
@Service
public class DwdSjWeatherPhenoMiManagerImpl extends BaseManagerImpl<DwdSjWeatherPhenoMiDao, DwdSjWeatherPhenoMi> implements DwdSjWeatherPhenoMiManager {

    @Resource
    private UserDao userDao;

    @Resource
    private DwdSjWeatherPhenoMiDao dwdSjWeatherPhenoMiDao;

    @Resource
    private DwdSjWeatherPhenoMiDtoMapper dwdSjWeatherPhenoMiDtoMapper ;

    @Resource
    private ManageCommonService manageCommonService;


    @Override
    public PageList<DwdSjWeatherPhenoMiDto> pageQuery(QueryFilter<DwdSjWeatherPhenoMi> queryFilter) {
        PageList<DwdSjWeatherPhenoMi> result = query(queryFilter);
        PageList<DwdSjWeatherPhenoMiDto> r = new PageList<DwdSjWeatherPhenoMiDto>(
                result.getRows().stream().map(e -> {
                            DwdSjWeatherPhenoMiDto t = dwdSjWeatherPhenoMiDtoMapper.toDto(e);



                            return t;
                        }
                ).collect(Collectors.toList())
        );
        r.setTotal(result.getTotal());
        r.setPage(result.getPage());
        r.setPageSize(result.getPageSize());
        return r;
    }

    @Override
    public String createInfo(DwdSjWeatherPhenoMi t) {
        int i = this.baseMapper.insert(t);
        if(i>0){
            return t.getId();
        }
        return null;
    }

    @Override
    public String updateInfo(DwdSjWeatherPhenoMi t) {
        this.baseMapper.updateById(t);
        return t.getId();
    }

    @Override
    public void deleteInfo(DwdSjWeatherPhenoMi t) {
        this.baseMapper.deleteById(t.getId());
    }


    public String create(DwdSjWeatherPhenoMiDto dto) {
        DwdSjWeatherPhenoMi t = dwdSjWeatherPhenoMiDtoMapper.toEntity(dto);
        int i = this.baseMapper.insert(t);
        if (i > 0) {
            return t.getId();
        }
        return null;
    }


    public String update(DwdSjWeatherPhenoMiDto dto) {
        DwdSjWeatherPhenoMi t = dwdSjWeatherPhenoMiDtoMapper.toEntity(dto);
        this.baseMapper.updateById(t);


        return t.getId();
    }

    public boolean delete(List<String> ids) {
        for (String id : ids) {

            int count = this.baseMapper.deleteById(id);
            if (count == 0) {
                return false;
            }
        }
        return true;
    }




}
