package com.artfess.manage.dwd.manager.impl;


import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.manage.base.ManageCommonService;
import com.artfess.manage.dwd.dao.DwdSjBusDepartedDao;
import com.artfess.manage.dwd.manager.DwdSjBusDepartedManager;
import com.artfess.manage.dwd.manager.dto.DwdSjBusDepartedDto;
import com.artfess.manage.dwd.manager.mapper.DwdSjBusDepartedDtoMapper;
import com.artfess.manage.dwd.model.DwdSjBusDeparted;
import com.artfess.uc.dao.UserDao;
import com.artfess.uc.model.User;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.stream.Collectors;



/**
 * 长途汽车-长途汽车历史发车 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author yuanhc
 * @since 2022-09-27
 */
@Service
public class DwdSjBusDepartedManagerImpl extends BaseManagerImpl<DwdSjBusDepartedDao, DwdSjBusDeparted> implements DwdSjBusDepartedManager {

    @Resource
    private UserDao userDao;

    @Resource
    private DwdSjBusDepartedDao dwdSjBusDepartedDao;

    @Resource
    private DwdSjBusDepartedDtoMapper dwdSjBusDepartedDtoMapper ;

    @Resource
    private ManageCommonService manageCommonService;


    @Override
    public PageList<DwdSjBusDepartedDto> pageQuery(QueryFilter<DwdSjBusDeparted> queryFilter) {
        PageList<DwdSjBusDeparted> result = query(queryFilter);
        PageList<DwdSjBusDepartedDto> r = new PageList<DwdSjBusDepartedDto>(
                result.getRows().stream().map(e -> {
                            DwdSjBusDepartedDto t = dwdSjBusDepartedDtoMapper.toDto(e);


                            if(e.getCreateBy()!=null){
                               User user = userDao.selectById(e.getCreateBy());
                               if(user!=null){
                                   t.setCreateByName(user.getFullname());
                               }
                            }

                            return t;
                        }
                ).collect(Collectors.toList())
        );
        r.setTotal(result.getTotal());
        r.setPage(result.getPage());
        r.setPageSize(result.getPageSize());
        return r;
    }

    @Override
    public String createInfo(DwdSjBusDeparted t) {
        int i = this.baseMapper.insert(t);
        if(i>0){
            return t.getId();
        }
        return null;
    }

    @Override
    public String updateInfo(DwdSjBusDeparted t) {
        this.baseMapper.updateById(t);
        return t.getId();
    }

    @Override
    public void deleteInfo(DwdSjBusDeparted t) {
        this.baseMapper.deleteById(t.getId());
    }


    public String create(DwdSjBusDepartedDto dto) {
        DwdSjBusDeparted t = dwdSjBusDepartedDtoMapper.toEntity(dto);
        int i = this.baseMapper.insert(t);
        if (i > 0) {
            return t.getId();
        }
        return null;
    }


    public String update(DwdSjBusDepartedDto dto) {
        DwdSjBusDeparted t = dwdSjBusDepartedDtoMapper.toEntity(dto);
        this.baseMapper.updateById(t);


        return t.getId();
    }

    public boolean delete(List<String> ids) {
        for (String id : ids) {

            int count = this.baseMapper.deleteById(id);
            if (count == 0) {
                return false;
            }
        }
        return true;
    }




}
