package com.artfess.manage.dwd.manager.impl;


import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.manage.dwd.dao.DwdLkEpidemicCityDao;
import com.artfess.manage.dwd.manager.DwdLkEpidemicCityManager;
import com.artfess.manage.dwd.manager.dto.DwdLkEpidemicCityDto;
import com.artfess.manage.dwd.manager.mapper.DwdLkEpidemicCityDtoMapper;
import com.artfess.manage.dwd.model.DwdLkEpidemicCity;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.stream.Collectors;

/**
 * 风险城市维护 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author yuanhc
 * @since 2022-11-06
 */
@Service
public class DwdLkEpidemicCityManagerImpl extends BaseManagerImpl<DwdLkEpidemicCityDao, DwdLkEpidemicCity> implements DwdLkEpidemicCityManager {

    @Resource
    private DwdLkEpidemicCityDao dwdLkEpidemicCityDao;

    @Resource
    private DwdLkEpidemicCityDtoMapper dwdLkEpidemicCityDtoMapper ;

    @Override
    public PageList<DwdLkEpidemicCityDto> pageQuery(QueryFilter<DwdLkEpidemicCity> queryFilter) {
        PageList<DwdLkEpidemicCity> result = query(queryFilter);
        PageList<DwdLkEpidemicCityDto> r = new PageList<DwdLkEpidemicCityDto>(
                result.getRows().stream().map(e -> {
                            DwdLkEpidemicCityDto t = dwdLkEpidemicCityDtoMapper.toDto(e);
                            return t;
                        }
                ).collect(Collectors.toList())
        );
        r.setTotal(result.getTotal());
        r.setPage(result.getPage());
        r.setPageSize(result.getPageSize());
        return r;
    }

    @Override
    public String createInfo(DwdLkEpidemicCity t) {
        int i = this.baseMapper.insert(t);
        if(i>0){
            return t.getId();
        }
        return null;
    }

    @Override
    public String updateInfo(DwdLkEpidemicCity t) {
        this.baseMapper.updateById(t);
        return t.getId();
    }

    @Override
    public void deleteInfo(DwdLkEpidemicCity t) {
        this.baseMapper.deleteById(t.getId());
    }
}
