package com.artfess.manage.dwd.manager.dto;

import com.artfess.manage.base.ManageBaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;



/**
 * dwd_sj_cq_event
 *
 * @company 阿特菲斯信息技术有限公司
 * @author yuanhc
 * @since 2022-10-08
 */
@Data
@ApiModel(value="DwdSjCqEventDto", description="数据中台-事件表DTO对象")
public class DwdSjCqEventDto extends ManageBaseModel<DwdSjCqEventDto> {


    /** 主键_ID */
    @ApiModelProperty(value = "主键_ID")
    private String id;




    /** 事件ID */
    @ApiModelProperty(value = "事件ID")
    private String eventId;




    /** 事件来源 */
    @ApiModelProperty(value = "事件来源")
    private String eventSrc;




    /** 事件源ID */
    @ApiModelProperty(value = "事件源ID")
    private String eventSrcId;




    /** 事件名称 */
    @ApiModelProperty(value = "事件名称")
    private String eventTitle;




    /** 区域ID */
    @ApiModelProperty(value = "区域ID")
    private String regionId;




    /** 紧急程度 */
    @ApiModelProperty(value = "紧急程度")
    private String eventLevel;




    /** 事件描述 */
    @ApiModelProperty(value = "事件描述")
    private String eventDesc;




    /** 事件发生时间 */
    @ApiModelProperty(value = "事件发生时间")
    private LocalDateTime eventTime;




    /** 经纬度 */
    @ApiModelProperty(value = "经纬度")
    private String lnglat;




    /** 事件地址 */
    @ApiModelProperty(value = "事件地址")
    private String eventAddr;




    /** 创建人 */
    @ApiModelProperty(value = "创建人")
    private String createUserId;




    /** 是否应急事件 */
    @ApiModelProperty(value = "是否应急事件")
    private Integer emergency;




    /** 事件状态 */
    @ApiModelProperty(value = "事件状态")
    private Integer eventStatus;




    /** 事件分类ID */
    @ApiModelProperty(value = "事件分类ID")
    private String eventClassId;




    /** 受理时间 */
    @ApiModelProperty(value = "受理时间")
    private LocalDateTime eventAssignTime;




    /** 是否评估 */
    @ApiModelProperty(value = "是否评估")
    private Integer evaluateFlag;




    /** 评估内容 */
    @ApiModelProperty(value = "评估内容")
    private String evaluateContent;




    /** 评估时间 */
    @ApiModelProperty(value = "评估时间")
    private LocalDateTime evaluateTime;




    /** 是否归档 */
    @ApiModelProperty(value = "是否归档")
    private Integer archiveFlag;




    /** 归档日期 */
    @ApiModelProperty(value = "归档日期")
    private LocalDateTime archiveTime;




    @ApiModelProperty(value = "")
    private String passerName;




    @ApiModelProperty(value = "")
    private String passerPhone;




    @ApiModelProperty(value = "")
    private String devCode;




    @ApiModelProperty(value = "")
    private String devName;




    @ApiModelProperty(value = "")
    private Integer eventType;




    @ApiModelProperty(value = "")
    private Integer peopleCount;




    @ApiModelProperty(value = "")
    private Integer threshold;




    /** 排序 */
    @ApiModelProperty(value = "排序")
    private Integer sn;




    /** 备注 */
    @ApiModelProperty(value = "备注")
    private String memo;




    /** 处理人列表 */
    @ApiModelProperty(value = "处理人列表")
    private String handleUserList;




    /** 处理意见列表 */
    @ApiModelProperty(value = "处理意见列表")
    private String handleContList;




    /** 处理时间 */
    @ApiModelProperty(value = "处理时间")
    private String handleTimeList;




    /** 勤务岗位区域 */
    @ApiModelProperty(value = "勤务岗位区域")
    private String dutyJobId;





    private String createByName;

}
