package com.artfess.manage.dwd.manager;


import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.manage.dwd.manager.dto.DwdSjStationArrivedDto;
import com.artfess.manage.dwd.model.DwdSjStationArrived;

import java.util.List;

/**
 * 国铁重庆北站-历史到达人数 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author yuanhc
 * @since 2022-09-27
 */
public interface DwdSjStationArrivedManager extends BaseManager<DwdSjStationArrived> {

    /**
     * 条件分页查询
     * @param queryFilter
     * @return
     */
    PageList<DwdSjStationArrivedDto> pageQuery(QueryFilter<DwdSjStationArrived> queryFilter);

    /**
     * 新增
     * @param t
     * @return
     */
    String createInfo(DwdSjStationArrived t);

    /**
     * 更新
     * @param t
     * @return
     */
    String updateInfo(DwdSjStationArrived t);

    /**
     * 删除
     * @param t
     */
    void deleteInfo(DwdSjStationArrived t);


    String create(DwdSjStationArrivedDto dto);

    String update(DwdSjStationArrivedDto dto);

    boolean delete(List<String> ids);



}
