package com.artfess.manage.dwd.manager;


import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.manage.dwd.manager.dto.DwdLkEpidemicPreventionInformationDto;
import com.artfess.manage.dwd.model.DwdLkEpidemicPreventionInformation;

import javax.servlet.http.HttpServletResponse;
import java.text.ParseException;
import java.util.List;

/**
 * 防疫信息填写 服务类
 *
 * @author yuanhc
 * @company 阿特菲斯信息技术有限公司
 * @since 2022-11-06
 */
public interface DwdLkEpidemicPreventionInformationManager extends BaseManager<DwdLkEpidemicPreventionInformation> {

    /**
     * 条件分页查询
     *
     * @param queryFilter
     * @return
     */
    PageList<DwdLkEpidemicPreventionInformationDto> pageQuery(QueryFilter<DwdLkEpidemicPreventionInformation> queryFilter);

    /**
     * 新增
     *
     * @param t
     * @return
     */
    String createInfo(DwdLkEpidemicPreventionInformation t);

    /**
     * 更新
     *
     * @param t
     * @return
     */
    String updateInfo(DwdLkEpidemicPreventionInformation t);

    /**
     * 删除
     *
     * @param t
     */
    void deleteInfo(DwdLkEpidemicPreventionInformation t);


    String create(DwdLkEpidemicPreventionInformationDto dto);

    String update(DwdLkEpidemicPreventionInformationDto dto);

    boolean delete(List<String> ids);

    public void export(HttpServletResponse response,
                       QueryFilter<DwdLkEpidemicPreventionInformation> queryFilter) throws ParseException;

}
