package com.artfess.manage.duty.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.List;

/**
 * @Description: 新每天排班信息
 * @ClassName: WorkArrangeInfoVo
 * @Author: wjl
 * @Date: 2022/8/4 23:12
 * @Version: 1.0
 */
@Data
public class WorkArrangeInfoVo {

    private String arrId;

    private String tid;

    private String arrangeDate;

    private String className;

    private String classId;

    private String mids;

    List<WorkArrangeMemberInfoVo> members;

    private String team;

    private String dataType;

    private String color;

    @DateTimeFormat(pattern = "HH:mm")
    @JsonFormat(pattern = "HH:mm",timezone="GMT+8")
    private String startDate;

    @DateTimeFormat(pattern = "HH:mm")
    @JsonFormat(pattern = "HH:mm",timezone="GMT+8")
    private String endDate;


}
