package com.artfess.manage.duty.dao;

import com.artfess.manage.duty.model.CmgtDutyTeamMember;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;
import java.util.Map;

/**
 * 勤务队员信息 Mapper 接口
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 超级管理员
 * @since 2022-07-20
 */
public interface CmgtDutyTeamMemberDao extends BaseMapper<CmgtDutyTeamMember> {

    @Select("select m.NAME_ mname,m.ID_ id,t.ORG_NAME_ orgName,m.POST_ post,m.PHONE_ phone,m.TEAM_ID_ teamId,t.name_ teamName,m.ORG_ID_ orgId from cmgt_duty_team_member m,cmgt_duty_team t\n" +
            " where m.TEAM_ID_ = t.ID_ and t.ORG_ID_ = (select t1.ORG_ID_ from cmgt_duty_team t1 where t1.ID_ = #{teamid})")
    public List<Map<String, Object>> findAllMembersByTeamId(@Param("teamid") String teamid);

    @Select("select m.NAME_ mname,m.ID_ id,(select name_ from uc_org o where o.id_=m.ORG_ID_) orgName,m.POST_ post,m.PHONE_ phone,m.TEAM_ID_ teamId,'未分组' teamName,m.ORG_ID_ orgId from cmgt_duty_team_member m\n" +
            " where m.TEAM_ID_ is null and  m.ORG_ID_ = #{orgId} ")
    public List<Map<String, Object>> findMembersUngroupedByOrgId(@Param("orgId") String orgId);

}
