package com.artfess.manage.dingding;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.util.StringUtil;
import com.artfess.manage.duty.manager.CmgtDutyTeamManager;
import com.artfess.manage.duty.model.CmgtDutyTeam;
import com.artfess.manage.duty.model.CmgtDutyTeamMember;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

/**
 * 勤务小组信息 前端控制器
 *
 * @author wjl
 * @company 阿特菲斯信息技术有限公司
 * @since 2022-07-20
 */
@Slf4j
@Api(tags = "面向钉钉接口-勤务管理")
@RestController
@RequestMapping("/manager/dingding/duty/")
@ApiGroup(group = {ApiGroupConsts.MANAGER_BIZ})
public class CmgtDutyController extends BaseController<CmgtDutyTeamManager, CmgtDutyTeam> {

    @Resource
    private CmgtDutyTeamManager cmgtDutyTeamManager;

    @GetMapping("/findTeams")
    @ApiOperation("查询部门下勤务小组")
    public List<CmgtDutyTeam> findByOrgId(String orgId) {
        return cmgtDutyTeamManager.findByOrgId(orgId);
    }


    /**
     * 调整为直接用PC端的分页查询接口
     */
    @GetMapping("/findTeamMembers")
    @ApiOperation("查询勤务人员（未用）")
    @Deprecated
    public List<CmgtDutyTeamMember> findTeamMembers(String orgId, String teamId) {

        if (StringUtil.isNotEmpty(teamId)) {
            return cmgtDutyTeamManager.findTeamMemberByTeamId(teamId);
        } else {
            return cmgtDutyTeamManager.findTeamMemberByOrgId(orgId);
        }
    }

}
