package com.artfess.manage.safty.manager;


import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.manage.safty.manager.dto.CmgtSaftyTrainingRecordDto;
import com.artfess.manage.safty.model.CmgtSaftyTrainingRecord;

import java.util.List;

/**
 * 安全培训记录 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author yuanhc
 * @since 2022-09-03
 */
public interface CmgtSaftyTrainingRecordManager extends BaseManager<CmgtSaftyTrainingRecord> {

    /**
     * 条件分页查询
     * @param queryFilter
     * @return
     */
    PageList<CmgtSaftyTrainingRecordDto> pageQuery(QueryFilter<CmgtSaftyTrainingRecord> queryFilter);

    /**
     * 新增
     * @param t
     * @return
     */
    String createInfo(CmgtSaftyTrainingRecord t);

    /**
     * 更新
     * @param t
     * @return
     */
    String updateInfo(CmgtSaftyTrainingRecord t);

    /**
     * 删除
     * @param t
     */
    void deleteInfo(CmgtSaftyTrainingRecord t);


    String create(CmgtSaftyTrainingRecordDto dto);

    String update(CmgtSaftyTrainingRecordDto dto);

    boolean delete(List<String> ids);



}
