package com.artfess.manage.safty.manager;


import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.manage.safty.manager.dto.CmgtSaftyPlanTaskDto;
import com.artfess.manage.safty.model.CmgtSaftyPlanTask;

import java.util.List;

/**
 * 安全计划任务 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author yuanhc
 * @since 2022-09-03
 */
public interface CmgtSaftyPlanTaskManager extends BaseManager<CmgtSaftyPlanTask> {

    /**
     * 条件分页查询
     * @param queryFilter
     * @return
     */
    PageList<CmgtSaftyPlanTaskDto> pageQuery(QueryFilter<CmgtSaftyPlanTask> queryFilter);

    /**
     * 新增
     * @param t
     * @return
     */
    String createInfo(CmgtSaftyPlanTask t);

    /**
     * 更新
     * @param t
     * @return
     */
    String updateInfo(CmgtSaftyPlanTask t);

    /**
     * 删除
     * @param t
     */
    void deleteInfo(CmgtSaftyPlanTask t);


    String create(CmgtSaftyPlanTaskDto dto);

    String update(CmgtSaftyPlanTaskDto dto);

    boolean delete(List<String> ids);


    /**
     *
     * @param planId
     * @return
     */
    List<CmgtSaftyPlanTask> selectListByPlanId(String planId) ;

}
