package com.artfess.manage.safty.manager;


import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.manage.safty.manager.dto.CmgtSaftyAppraisalDto;
import com.artfess.manage.safty.model.CmgtSaftyAppraisal;

import java.util.List;

/**
 * 安全目标考核 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author yuanhc
 * @since 2022-09-03
 */
public interface CmgtSaftyAppraisalManager extends BaseManager<CmgtSaftyAppraisal> {

    /**
     * 条件分页查询
     * @param queryFilter
     * @return
     */
    PageList<CmgtSaftyAppraisalDto> pageQuery(QueryFilter<CmgtSaftyAppraisal> queryFilter);

    /**
     * 新增
     * @param t
     * @return
     */
    String createInfo(CmgtSaftyAppraisal t);

    /**
     * 更新
     * @param t
     * @return
     */
    String updateInfo(CmgtSaftyAppraisal t);

    /**
     * 删除
     * @param t
     */
    void deleteInfo(CmgtSaftyAppraisal t);


    String create(CmgtSaftyAppraisalDto dto);

    String update(CmgtSaftyAppraisalDto dto);

    boolean delete(List<String> ids);



}
