package com.artfess.manage.safty;


import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.manage.safty.dao.CmgtSaftyPlanDao;
import com.artfess.manage.safty.dao.CmgtSaftyPlanTaskDao;
import com.artfess.manage.safty.dao.CmgtSaftyTargetDao;
import com.artfess.manage.safty.dao.CmgtSaftyTrainingPlanDao;
import com.artfess.manage.safty.dao.CmgtSaftyTrainingProjectDao;
import com.artfess.manage.safty.dao.CmgtSaftyTrainingRecordDao;
import com.artfess.manage.safty.model.CmgtSaftyPlan;
import com.artfess.manage.safty.model.CmgtSaftyTarget;
import com.artfess.manage.safty.model.CmgtSaftyTrainingProject;
import com.artfess.uc.dao.OrgDao;
import com.artfess.uc.dao.UserDao;
import com.artfess.uc.model.Org;
import com.artfess.uc.model.User;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 安全工作计划信息 服务实现类
 *
 * @author yuanhc
 * @company 阿特菲斯信息技术有限公司
 * @since 2022-08-01
 */
@Service
public class CmgtSaftySelectOptions {

    @Resource
    private CmgtSaftyTrainingProjectDao cmgtSaftyTrainingProjectDao;

    @Resource
    private CmgtSaftyTrainingPlanDao cmgtSaftyTrainingPlanDao;

    @Resource
    UserDao userDao;

    @Resource
    OrgDao orgDao;

    @Resource
    private CmgtSaftyTargetDao cmgtSaftyTargetDao;

    @Resource
    private CmgtSaftyTrainingRecordDao cmgtSaftyTrainingRecordDao;

    /**
     * 查询安全目标
     *
     * @return
     */
    public List<CmgtSaftyTarget> getCmgtSaftyTargets() {
        return cmgtSaftyTargetDao.selectList(null);
    }


    @Resource
    private CmgtSaftyPlanTaskDao cmgtSaftyPlanTaskDao;

    @Resource
    private CmgtSaftyPlanDao cmgtSaftyPlakDao;

    /**
     * 查询培训项目
     *
     * @return
     */
    public List<CmgtSaftyTrainingProject> getCmgtSaftyTrainingProjects() {
        return this.getCmgtSaftyTrainingProjects(null);
    }

    public List<CmgtSaftyTrainingProject> getCmgtSaftyTrainingProjects(String query) {
        if (StringUtil.isEmpty(query)) {
            return cmgtSaftyTrainingProjectDao.selectList(null);
        } else {
            QueryWrapper<CmgtSaftyTrainingProject> queryWrapper = new QueryWrapper();
            queryWrapper.like("name_", "%" + query + "%");
            return cmgtSaftyTrainingProjectDao.selectList(queryWrapper);
        }
    }


    public List<User> getUsers() {
        return getUsers(null);
    }

    public List<User> getUsers(String query) {
        if (StringUtil.isEmpty(query)) {
            return userDao.selectList(null);
        }
        QueryWrapper<User> queryWrapper = new QueryWrapper();
        queryWrapper.like("FULLNAME_", "%" + query + "%");
        return userDao.selectList(queryWrapper);
    }

    public List<Org> getOrgs() {
        return getOrgs(null);
    }

    public List<Org> getOrgs(String query) {
        if (StringUtil.isEmpty(query)) {
            return orgDao.selectList(null);
        }
        QueryWrapper<Org> queryWrapper = new QueryWrapper();
        queryWrapper.like("name_", "%" + query + "%");
        return orgDao.selectList(queryWrapper);
    }


    public List<JSONObject> getCmgtSaftyTrainingPlans() {
        return cmgtSaftyTrainingPlanDao.selectList(null).stream().map(p -> {
            return JSONUtil.createObj().putOpt("label", p.getTrainingDate() + "   " + p.getContent()).putOpt("value", p.getId());
        }).collect(Collectors.toList());
    }


    public List<JSONObject> getCmgtSaftyTrainingRecords() {
        return cmgtSaftyTrainingRecordDao.selectList(null).stream().map(p -> {
            return JSONUtil.createObj().putOpt("label", p.getTrainingDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")) + "  - " + p.getLocation()).putOpt("value", p.getId());
        }).collect(Collectors.toList());
    }


    public List<JSONObject> getCmgtDutyPlanTasks() {
        return cmgtSaftyPlanTaskDao.selectList(null).stream().map(p -> {
            CmgtSaftyPlan plan = cmgtSaftyPlakDao.selectById(p.getPlanId());
            return JSONUtil.createObj().putOpt("label", plan.getPlanName() + " - " + p.getName() + "  -  " + p.getTaskUser() + "  -  " + p.getTaskDate()).putOpt("value", p.getId());
        }).collect(Collectors.toList());
    }

}
