package com.artfess.manage.material.model;

import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 订单物资到货签收入库表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-04-24
 */
@Data
@ApiModel(value="CmgtMaterialSignWarehouse对象", description="订单物资到货签收入库表")
public class CmgtMaterialSignWarehouse extends AutoFillModel<CmgtMaterialSignWarehouse> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @NotBlank(message = "请选择采购订单", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "采购订单_ID（外键）")
    @TableField("order_id_")
    private String orderId;

    @ApiModelProperty(value = "签收入库单据号（唯一值）")
    @TableField("code_")
    private String code;

    @NotBlank(message = "请选择供应商", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "到货供应商_名称（可多选用 | 隔开）")
    @TableField("supplier_name_")
    private String supplierName;

    @ApiModelProperty(value = "到货验收&签收描述")
    @TableField("descripton_")
    private String descripton;

    @ApiModelProperty(value = "签收人")
    @TableField("applicant_")
    private String applicant;

    @ApiModelProperty(value = "签收部门")
    @TableField("org_")
    private String org;

    @ApiModelProperty(value = "签收时间")
    @TableField("approved_date_")
    private LocalDateTime approvedDate;

    @ApiModelProperty(value = "物资产品签收金额（元）")
    @TableField("sign_amount_")
    private BigDecimal signAmount;

    @NotBlank(message = "请选择状态", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "状态（1：签收未入库  2：已入库）")
    @TableField("status_")
    private String status;

    @NotBlank(message = "请选择仓库", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "入库仓库（参考字典）")
    @TableField("warehouse_")
    private String warehouse;

    @ApiModelProperty(value = "入库时间（入库后则修改库存表数据，采购订单状态为已完成）")
    @TableField("inout_date_")
    private LocalDateTime inoutDate;

    @ApiModelProperty(value = "排序")
    @TableField("sn_")
    private Integer sn;

    @ApiModelProperty(value = "备注")
    @TableField("memo_")
    private String memo;

    @TableLogic
    @ApiModelProperty(value = "是否已删，1已删除，0未删除")
    @TableField(value = "IS_DELE_", updateStrategy = FieldStrategy.NOT_EMPTY)
    private String isDele;

    @ApiModelProperty(value = "数据时间戳")
    @TableField("last_time_")
    private LocalDateTime lastTime;

    @ApiModelProperty(value = "订单物资到货签收入库明细")
    @TableField(exist = false)
    private List<CmgtMaterialSignWarehouseDetail> detailList;


}
