package com.artfess.manage.material.model;

import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @Description: 物资库存
 * @ClassName: CmgtMaterialQuantity
 * @Author: wjl
 * @Date: 2022/8/3 11:25
 * @Version: 1.0
 */
@Data
@ApiModel(value = "CmgtMaterialQuantity对象", description = "物资库存")
public class CmgtMaterialQuantity extends AutoFillModel<CmgtMaterialQuantity> {

    private static final long serialVersionUID = 1L;

    @NotNull(message = "修改必须指定id", groups = {UpdateGroup.class})
    @Null(message = "新增不能指定id", groups = {AddGroup.class})
    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @NotNull(message = "请选择所属仓库", groups = {AddGroup.class, UpdateGroup.class})
    @TableField(value = "WAREHOUSE_")
    @ApiModelProperty(value = "所属仓库")
    private String warehouse;

    @TableField(exist = false)
    @ApiModelProperty(value = "物资分类ID")
    private String classId;

    @NotNull(message = "请选择物资", groups = {AddGroup.class, UpdateGroup.class})
    @TableField(value = "MATERIAL_ID_")
    @ApiModelProperty(value = "物资ID")
    private String mid;

    @TableField(value = "MATERIAL_NAME_")
    @ApiModelProperty(value = "物资名称")
    private String name;

    @ApiModelProperty(value = "规格")
    @TableField("MODEL_")
    private String model;

    @ApiModelProperty(value = "计量单位")
    @TableField("UNIT_")
    private String unit;

    @ApiModelProperty(value = "库存剩余数量")
    @TableField("QUANTITY_")
    private BigDecimal quantity;

    @ApiModelProperty(value = "剩余价值")
    @TableField("AMOUNT_")
    private BigDecimal amount;

    @ApiModelProperty(value = "数据时间戳")
    @TableField("LAST_TIME_")
    private LocalDateTime lastTime;

    @TableField(exist = false)
    @ApiModelProperty(value = "物资分类名称")
    private String className;

    @TableField(exist = false)
    @ApiModelProperty(value = "预估单价")
    private BigDecimal price;
}
