package com.artfess.manage.material.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 采购单关联表供应商
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-04-24
 */
@Data
@ApiModel(value="CmgtMaterialOrderSupplier对象", description="采购单关联表供应商")
public class CmgtMaterialOrderSupplier extends BaseModel<CmgtMaterialOrderSupplier> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "采购订单_ID")
    @TableField("order_id_")
    private String orderId;

    @ApiModelProperty(value = "供应商_ID")
    @TableField("supplier_id_")
    private String supplierId;

}
