package com.artfess.manage.material.model;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 采购订单明细表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-04-24
 */
@Data
@ApiModel(value="CmgtMaterialOrderDetail对象", description="采购订单明细表")
public class CmgtMaterialOrderDetail extends BaseModel<CmgtMaterialOrderDetail> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "采购订单id")
    @TableField("order_id_")
    private String orderId;

    @ApiModelProperty(value = "物资id")
    @TableField("material_id_")
    private String materialId;

    @ApiModelProperty(value = "品名")
    @TableField("name_")
    private String name;

    @ApiModelProperty(value = "型号")
    @TableField("model_")
    private String model;

    @ApiModelProperty(value = "计量单位")
    @TableField("unit_")
    private String unit;

    @ApiModelProperty(value = "单价（元）")
    @TableField("price_")
    private BigDecimal price;

    @ApiModelProperty(value = "数量")
    @TableField("quantity_")
    private BigDecimal quantity;

    @ApiModelProperty(value = "描述")
    @TableField("description_")
    private String description;

    @ApiModelProperty(value = "排序")
    @TableField("sn_")
    private Integer sn;

}
