package com.artfess.manage.material.model;

import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 物资产品-库存流水记录表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-04-24
 */
@Data
@ApiModel(value="CmgtMaterialFlowLog对象", description="物资产品-库存流水记录表")
public class CmgtMaterialFlowLog extends AutoFillModel<CmgtMaterialFlowLog> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "出入库标识（1：签收入库  2：出库领用）")
    @TableField("inout_type_")
    private String inoutType;

    @NotBlank(message = "请选择领用申请单",groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "出入库单据_ID（外键）")
    @TableField("inout_id")
    private String inoutId;

    @ApiModelProperty(value = "所属仓库(参考字典)")
    @TableField("warehouse_")
    private String warehouse;

    @ApiModelProperty(value = "物资分类_ID")
    @TableField(exist = false)
    private String classId;

    @ApiModelProperty(value = "物资_ID")
    @TableField("material_id_")
    private String materialId;

    @ApiModelProperty(value = "物资名称(品名)")
    @TableField("material_name_")
    private String materialName;

    @ApiModelProperty(value = "型号")
    @TableField("model_")
    private String model;

    @ApiModelProperty(value = "计量单位")
    @TableField("unit_")
    private String unit;

    @ApiModelProperty(value = "当前出入库数量")
    @TableField("quantity_")
    private BigDecimal quantity;

    @ApiModelProperty(value = "出入库人")
    @TableField("forthe_user_")
    private String fortheUser;

    @ApiModelProperty(value = "出入库部门")
    @TableField("forthe_org_")
    private String fortheOrg;


    @ApiModelProperty(value = "出入库具体时间")
    @TableField("for_the_date_")
    private LocalDateTime forTheDate;

    @TableLogic
    @ApiModelProperty(value = "是否已删，1已删除，0未删除")
    @TableField(value = "IS_DELE_", updateStrategy = FieldStrategy.NOT_EMPTY)
    private String isDele;

    @ApiModelProperty(value = "版本号")
    @TableField("version_")
    private Integer version;

    @ApiModelProperty(value = "数据时间戳")
    @TableField("last_time_")
    private LocalDateTime lastTime;

    @ApiModelProperty(value = "单项领用金额")
    @TableField(exist = false)
    private BigDecimal amount;

}
