package com.artfess.manage.material.manager.impl;

import com.artfess.base.util.StringUtil;
import com.artfess.manage.material.model.CmgtMaterialUsedDetail;
import com.artfess.manage.material.dao.CmgtMaterialUsedDetailDao;
import com.artfess.manage.material.manager.CmgtMaterialUsedDetailManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 常用物资-明细表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-04-24
 */
@Service
public class CmgtMaterialUsedDetailManagerImpl extends BaseManagerImpl<CmgtMaterialUsedDetailDao, CmgtMaterialUsedDetail> implements CmgtMaterialUsedDetailManager {

    @Override
    public List<CmgtMaterialUsedDetail> findByOrgUseDetail(CmgtMaterialUsedDetail usedDetail) {
        QueryWrapper<CmgtMaterialUsedDetail> queryWrapper = new QueryWrapper<>();
        if(StringUtil.isNotEmpty(usedDetail.getCreateOrgId())) {
            queryWrapper.eq("create_org_id_", usedDetail.getCreateOrgId());
        }

        if(StringUtil.isNotEmpty(usedDetail.getName())) {
            queryWrapper.eq("name_", usedDetail.getName());
        }
        return this.baseMapper.selectList(queryWrapper);
    }
}
