package com.artfess.manage.material.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.manage.material.dao.CmgtMaterialPurchasingDetailDao;
import com.artfess.manage.material.manager.CmgtMaterialPurchasingDetailManager;
import com.artfess.manage.material.model.CmgtMaterialPurchasingDetail;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/**
 * 物资采购申请明细 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wujl
 * @since 2022-07-23
 */
@Service
@Transactional(readOnly = true)
public class CmgtMaterialPurchasingDetailManagerImpl extends BaseManagerImpl<CmgtMaterialPurchasingDetailDao, CmgtMaterialPurchasingDetail> implements CmgtMaterialPurchasingDetailManager {

    @Resource
    private CmgtMaterialPurchasingDetailDao cmgtMaterialPurchasingDetailDao;

    @Override
    public List<CmgtMaterialPurchasingDetail> findAllByPurchasingId(String purchasingId) {
        return cmgtMaterialPurchasingDetailDao.findAllByPurchasingId(purchasingId);
    }

    @Override
    @Transactional(readOnly = false)
    public void deleteByMaterialInfoId(String pId) {
        cmgtMaterialPurchasingDetailDao.deleteByMaterialInfoId(pId);
    }
}
