package com.artfess.manage.material.dao;

import com.artfess.manage.material.model.CmgtMaterialPurchasingDetail;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.type.JdbcType;

import java.util.List;

/**
 * 物资采购申请明细 Mapper 接口
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wujl
 * @since 2022-07-23
 */
public interface CmgtMaterialPurchasingDetailDao extends BaseMapper<CmgtMaterialPurchasingDetail> {

    /**
     * 根据物资申请单ID查询该申请下的所有物资信息
     * @param purchasingId
     * @return
     */
    @Select("select * from CMGT_MATERIAL_PURCHASING_DETAIL where  PURCHASING_ID_ = #{purchasingId}")
    @Results({
            @Result(column="ID_", property="id", jdbcType= JdbcType.VARCHAR, id=true),
            @Result(column="PURCHASING_ID_", property="purchasingId", jdbcType= JdbcType.VARCHAR),
            @Result(column="MATERIAL_INFO_ID_", property="materialInfoId", jdbcType= JdbcType.VARCHAR, id=true),
            @Result(column="NAME_", property="name", jdbcType= JdbcType.VARCHAR, id=true),
            @Result(column="MODEL_", property="model", jdbcType= JdbcType.VARCHAR, id=true),
            @Result(column="QUANTITY_", property="quantity", jdbcType= JdbcType.VARCHAR, id=true),
            @Result(column="DESCRIPTION_", property="description", jdbcType= JdbcType.VARCHAR, id=true)
    })
    public List<CmgtMaterialPurchasingDetail> findAllByPurchasingId(String purchasingId);

    /**
     *删除申请单下所有物资
     * @param pId 申请单ID
     */
    public void deleteByMaterialInfoId(String pId);
}
