package com.artfess.manage.dwd.model;

import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.manage.base.ManageBaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;

/**
 * dwd_sj_bus_departed
 *
 * @company 阿特菲斯信息技术有限公司
 * @author yuanhc
 * @since 2022-09-27
 */
@Data
@ApiModel(value="DwdSjBusDeparted对象", description="长途汽车-长途汽车历史发车")
//@FieldRepeat(fields = {"code","name"},message = "名称不能重复，请重新输入",groups = {AddGroup.class, UpdateGroup.class})
public class DwdSjBusDeparted extends ManageBaseModel<DwdSjBusDeparted> {


    /** 主键_ID */
    @NotNull(message = "修改必须指定id",groups = {UpdateGroup.class})
    @Null(message = "新增不能指定id",groups = {AddGroup.class})
    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    /** 发车日期 */
    @ApiModelProperty(value = "发车日期")
    @TableField("departure_date")
    private String departureDate;

    /** 班次号 */
    @ApiModelProperty(value = "班次号")
    @TableField("shift_number")
    private String shiftNumber;

    /** 线路名称 */
    @ApiModelProperty(value = "线路名称")
    @TableField("line_name")
    private String lineName;

    /** 车牌号 */
    @ApiModelProperty(value = "车牌号")
    @TableField("number_plate")
    private String numberPlate;

    /** 席位数 */
    @ApiModelProperty(value = "席位数")
    @TableField("seat")
    private String seat;

    /** 发车时间 */
    @ApiModelProperty(value = "发车时间")
    @TableField("departure_time")
    private String departureTime;

    /** 出发站点 */
    @ApiModelProperty(value = "出发站点")
    @TableField("departure_site")
    private String departureSite;

    /** 已售票数 */
    @ApiModelProperty(value = "已售票数")
    @TableField("tickets_purchased")
    private String ticketsPurchased;

    /** 已检票乘客数 */
    @ApiModelProperty(value = "已检票乘客数")
    @TableField("checked")
    private String checked;

    /** 执行票价 */
    @ApiModelProperty(value = "执行票价")
    @TableField("execute_fare")
    private String executeFare;

    /** 排序 */
    @ApiModelProperty(value = "排序")
    @TableField("sn_")
    private Integer sn;

    /** 备注 */
    @ApiModelProperty(value = "备注")
    @TableField("memo_")
    private String memo;

}
