package com.artfess.manage.dwd.model;

import com.artfess.base.entity.BaseModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import java.time.LocalDateTime;


/**
 * dwd_lk_epidemic_city
 *
 * @company 阿特菲斯信息技术有限公司
 * @author yuanhc
 * @since 2022-11-06
 */
@Data
@ApiModel(value="DwdLkEpidemicCity对象", description="风险城市维护")
//@FieldRepeat(fields = {"code","name"},message = "名称不能重复，请重新输入",groups = {AddGroup.class, UpdateGroup.class})
public class DwdLkEpidemicCity extends BaseModel<DwdLkEpidemicCity> {

    /** 主建ID */
    @NotNull(message = "修改必须指定id",groups = {UpdateGroup.class})
    @Null(message = "新增不能指定id",groups = {AddGroup.class})
    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private String id;

    /** 城市名称 */
    @ApiModelProperty(value = "城市名称")
    @TableField("city")
    @NotBlank(message = "城市名称",groups = {AddGroup.class,UpdateGroup.class})
    private String city;

    /** 风险城市标记：0-否；1-是 */
    @ApiModelProperty(value = "风险城市标记：0-否；1-是")
    @TableField("level")
    @NotNull(message = "风险城市标记：0-否；1-是",groups = {AddGroup.class,UpdateGroup.class})
    private Integer level;

    /** 更新时间 */
    @ApiModelProperty(value = "更新时间")
    @TableField("update_time")
    private LocalDateTime updateTime;


}
