package com.artfess.manage.dwd.manager.impl;


import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.artfess.manage.dwd.dao.DwdSjWeatherForcastMiDao;
import com.artfess.manage.dwd.manager.DwdSjManager;
import com.artfess.manage.dwd.model.DwdSjWeatherForcastMi;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.stream.Collectors;


/**
 * 来自互联网心知天气的天气预报 服务实现类
 *
 * @author yuanhc
 * @company 阿特菲斯信息技术有限公司
 * @since 2022-09-21
 */
@Service
public class DwdSjManagerImpl implements DwdSjManager {


    @Resource
    DwdSjWeatherForcastMiDao dwdSjWeatherForcastMiDao;

    static JSONObject weatherIcon = JSONUtil.createObj()
            .putOpt("雨", "el-icon-light-rain")
            .putOpt("暴雨", "el-icon-lightning")
            .putOpt("大雨", "el-icon-heavy-rain")
            .putOpt("高温", "el-icon-sunrise")
            .putOpt("晴转阴", "el-icon-sunrise-1")
            .putOpt("阴", "el-icon-sunset")
            .putOpt("晴", "el-icon-sunny")
            .putOpt("多云", "el-icon-cloudy")
            .putOpt("少云", "el-icon-partly-cloudy")
            .putOpt("阴转晴", "el-icon-cloudy-and-sunny")
            .putOpt("", "el-icon-moon")
            .putOpt("", "el-icon-moon-night");

    public List<DwdSjWeatherForcastMi> findWeatherForcastMi(String startDate, String endDate) {
        QueryWrapper<DwdSjWeatherForcastMi> queryWrapper = new QueryWrapper();
        queryWrapper.between("date", startDate, endDate);
        return dwdSjWeatherForcastMiDao.selectList(queryWrapper).stream().map(r -> {
            r.setCodeDay(weatherIcon.get(r.getTextDay()) + "");
            return r;
        }).collect(Collectors.toList());
    }


}
