package com.artfess.manage.dwd.manager.impl;


import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.manage.base.ManageCommonService;
import com.artfess.manage.dwd.dao.DwdSjCqEventDao;
import com.artfess.manage.dwd.manager.DwdSjCqEventManager;
import com.artfess.manage.dwd.manager.dto.DwdSjCqEventDto;
import com.artfess.manage.dwd.manager.mapper.DwdSjCqEventDtoMapper;
import com.artfess.manage.dwd.model.DwdSjCqEvent;
import com.artfess.uc.dao.UserDao;
import com.artfess.uc.model.User;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.stream.Collectors;



/**
 * 数据中台-事件表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author yuanhc
 * @since 2022-10-08
 */
@Service
public class DwdSjCqEventManagerImpl extends BaseManagerImpl<DwdSjCqEventDao, DwdSjCqEvent> implements DwdSjCqEventManager {

    @Resource
    private UserDao userDao;

    @Resource
    private DwdSjCqEventDao dwdSjCqEventDao;

    @Resource
    private DwdSjCqEventDtoMapper dwdSjCqEventDtoMapper ;

    @Resource
    private ManageCommonService manageCommonService;


    @Override
    public PageList<DwdSjCqEventDto> pageQuery(QueryFilter<DwdSjCqEvent> queryFilter) {
        PageList<DwdSjCqEvent> result = query(queryFilter);
        PageList<DwdSjCqEventDto> r = new PageList<DwdSjCqEventDto>(
                result.getRows().stream().map(e -> {
                            DwdSjCqEventDto t = dwdSjCqEventDtoMapper.toDto(e);


                            if(e.getCreateBy()!=null){
                               User user = userDao.selectById(e.getCreateBy());
                               if(user!=null){
                                   t.setCreateByName(user.getFullname());
                               }
                            }

                            return t;
                        }
                ).collect(Collectors.toList())
        );
        r.setTotal(result.getTotal());
        r.setPage(result.getPage());
        r.setPageSize(result.getPageSize());
        return r;
    }

    @Override
    public String createInfo(DwdSjCqEvent t) {
        int i = this.baseMapper.insert(t);
        if(i>0){
            return t.getId();
        }
        return null;
    }

    @Override
    public String updateInfo(DwdSjCqEvent t) {
        this.baseMapper.updateById(t);
        return t.getId();
    }

    @Override
    public void deleteInfo(DwdSjCqEvent t) {
        this.baseMapper.deleteById(t.getId());
    }


    public String create(DwdSjCqEventDto dto) {
        DwdSjCqEvent t = dwdSjCqEventDtoMapper.toEntity(dto);
        int i = this.baseMapper.insert(t);
        if (i > 0) {
            return t.getId();
        }
        return null;
    }


    public String update(DwdSjCqEventDto dto) {
        DwdSjCqEvent t = dwdSjCqEventDtoMapper.toEntity(dto);
        this.baseMapper.updateById(t);


        return t.getId();
    }

    public boolean delete(List<String> ids) {
        for (String id : ids) {

            int count = this.baseMapper.deleteById(id);
            if (count == 0) {
                return false;
            }
        }
        return true;
    }




}
