package com.artfess.manage.dwd.manager.impl;


import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.manage.dwd.dao.DwdLkFamilyMemberDao;
import com.artfess.manage.dwd.manager.DwdLkFamilyMemberManager;
import com.artfess.manage.dwd.manager.dto.DwdLkFamilyMemberDto;
import com.artfess.manage.dwd.manager.mapper.DwdLkFamilyMemberDtoMapper;
import com.artfess.manage.dwd.model.DwdLkFamilyMember;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.stream.Collectors;

/**
 * 家庭成员 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author yuanhc
 * @since 2022-11-06
 */
@Service
public class DwdLkFamilyMemberManagerImpl extends BaseManagerImpl<DwdLkFamilyMemberDao, DwdLkFamilyMember> implements DwdLkFamilyMemberManager {

    @Resource
    private DwdLkFamilyMemberDao dwdLkFamilyMemberDao;

    @Resource
    private DwdLkFamilyMemberDtoMapper dwdLkFamilyMemberDtoMapper ;

    @Override
    public PageList<DwdLkFamilyMemberDto> pageQuery(QueryFilter<DwdLkFamilyMember> queryFilter) {
        PageList<DwdLkFamilyMember> result = query(queryFilter);
        PageList<DwdLkFamilyMemberDto> r = new PageList<DwdLkFamilyMemberDto>(
                result.getRows().stream().map(e -> {
                            DwdLkFamilyMemberDto t = dwdLkFamilyMemberDtoMapper.toDto(e);
                            return t;
                        }
                ).collect(Collectors.toList())
        );
        r.setTotal(result.getTotal());
        r.setPage(result.getPage());
        r.setPageSize(result.getPageSize());
        return r;
    }

    @Override
    public String createInfo(DwdLkFamilyMember t) {
        int i = this.baseMapper.insert(t);
        if(i>0){
            return t.getId();
        }
        return null;
    }

    @Override
    public String updateInfo(DwdLkFamilyMember t) {
        this.baseMapper.updateById(t);
        return t.getId();
    }

    @Override
    public void deleteInfo(DwdLkFamilyMember t) {
        this.baseMapper.deleteById(t.getId());
    }
}
