package com.artfess.manage.duty.manager.dto;

import com.artfess.manage.base.ManageBaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;



/**
 * cmgt_duty_vehicle_gpsinfo
 *
 * @company 阿特菲斯信息技术有限公司
 * @author yuanhc
 * @since 2022-09-24
 */
@Data
@ApiModel(value="CmgtDutyVehicleGpsinfoDto", description="车辆GPS信息DTO对象")
public class CmgtDutyVehicleGpsinfoDto extends ManageBaseModel<CmgtDutyVehicleGpsinfoDto> {


    /** 主键_ID */
    @ApiModelProperty(value = "主键_ID")
    private String id;




    /** 所属车辆 */
    @ApiModelProperty(value = "所属车辆")
    private String vehicleId;

    private Object vehicleIdName;



    /** 车机时间 */
    @ApiModelProperty(value = "车机时间")
    private LocalDateTime sysTime;




    /** 接收时间 */
    @ApiModelProperty(value = "接收时间")
    private LocalDateTime receiveTime;




    /** ACC状态 */
    @ApiModelProperty(value = "ACC状态")
    private String accStatus;




    /** GPS是否有效 */
    @ApiModelProperty(value = "GPS是否有效")
    private String valid;




    /** 纬度 */
    @ApiModelProperty(value = "纬度")
    private String latitude;




    /** 经度 */
    @ApiModelProperty(value = "经度")
    private String longitude;




    /** 海拔高度 */
    @ApiModelProperty(value = "海拔高度")
    private String altitude;




    /** 卫星数 */
    @ApiModelProperty(value = "卫星数")
    private String satellites;




    /** GPS速度 */
    @ApiModelProperty(value = "GPS速度")
    private String gpsspeed;




    /** 方向 */
    @ApiModelProperty(value = "方向")
    private String direction;




    /** 位置精度 */
    @ApiModelProperty(value = "位置精度")
    private String pdop;




    /** 排序 */
    @ApiModelProperty(value = "排序")
    private Integer sn;




    /** 备注 */
    @ApiModelProperty(value = "备注")
    private String memo;





    private String createByName;

}
