package com.artfess.manage.duty.manager;

import cn.hutool.core.lang.tree.Tree;
import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.manage.duty.manager.dto.CmgtDutyTeamDto;
import com.artfess.manage.duty.model.CmgtDutyTeam;
import com.artfess.manage.duty.model.CmgtDutyTeamMember;

import java.util.List;

/**
 * 勤务小组信息 服务类
 *
 * @author wjl
 * @company 阿特菲斯信息技术有限公司
 * @since 2022-07-20
 */
public interface CmgtDutyTeamManager extends BaseManager<CmgtDutyTeam> {
    /**
     * 获取所有小组信息
     *
     * @return
     */
    List<CmgtDutyTeam> findAllTeam();

    /**
     * @param orgId
     * @return
     */
    public List<CmgtDutyTeam> findByOrgId(String orgId);

    /**
     * @param orgId
     * @return
     */
    public List<CmgtDutyTeamMember> findTeamMemberByOrgId(String orgId);

    /**
     * @param teamId
     * @return
     */
    public List<CmgtDutyTeamMember> findTeamMemberByTeamId(String teamId);

    /**
     * 查询综管局所属组织及小组
     *
     * @return
     */
    public List<Tree<String>> findOrgTeamTreeData();

    public PageList<CmgtDutyTeamDto> pageQuery(QueryFilter<CmgtDutyTeam> queryFilter);
}
